<?php
session_start();
require_once '../../config/db.php';
include '../../includes/layout2.php';

// Fetch branches
$branches = $conn->query("SELECT id, branch_name FROM branches ORDER BY branch_name")->fetch_all(MYSQLI_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Cashier Till Report - Delta Supermarkets</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      background: #f8f9fa;
      font-size: 13px;
    }
    .nav-tabs .nav-link.active {
      background-color: #007bff;
      color: #fff;
    }
    .card-header {
      background: #007bff;
      color: #fff;
      font-size: 14px;
      padding: 8px 15px;
    }
    label {
      font-weight: 500;
      font-size: 12px;
    }
    .form-control {
      font-size: 13px;
      padding: 4px 8px;
    }
    .summary-bar {
      background: #0056b3;
      color: #fff;
      padding: 10px 15px;
      margin-bottom: 10px;
      font-weight: bold;
      font-size: 14px;
      border-bottom: 3px solid #003087;
    }
    .summary-bar span {
      color: #ffdd57;
    }
    input[readonly] {
      background: #e3f2fd;
      font-weight: bold;
    }
    @media print {
      .no-print, .nav-tabs, .tab-content > .tab-pane:not(.active), .table-responsive {
        display: none !important;
      }
    }
  </style>
</head>
<body>
<div class="container my-3">
  <h5 class="text-center mb-3">Delta Supermarkets - Cashier Till Report</h5>

  <?php if (isset($_GET['success'])): ?>
    <div class="alert alert-success"><?php echo htmlspecialchars($_GET['success']); ?></div>
  <?php endif; ?>
  <?php if (isset($_GET['error'])): ?>
    <div class="alert alert-danger"><?php echo htmlspecialchars($_GET['error']); ?></div>
  <?php endif; ?>

  <div class="summary-bar">
    <div class="row">
      <div class="col"><strong>💰 Total Drop:</strong> <span id="grandDrop">0.00</span></div>
      <div class="col"><strong>💵 Total Cash:</strong> <span id="grandCash">0.00</span></div>
      <div class="col"><strong>📱 MPESA:</strong> <span id="grandMpesa">0.00</span></div>
      <div class="col"><strong>💳 VISA:</strong> <span id="grandVisa">0.00</span></div>
      <div class="col"><strong>🧮 Grand Total:</strong> <span id="grandAll">0.00</span></div>
    </div>
  </div>

  <form method="POST" action="save_till_report.php" id="tillReportForm" onsubmit="return confirm('Are you sure you want to save this report?')">
    <div class="row mb-3">
      <div class="col-md-4">
        <label>Branch</label>
        <select name="branch_id" class="form-select" required>
          <option value="">Select Branch</option>
          <?php foreach ($branches as $b): ?>
            <option value="<?= $b['id'] ?>"><?= htmlspecialchars($b['branch_name']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-4">
        <label>Date</label>
        <input type="date" name="report_date" class="form-control" value="<?= date('Y-m-d') ?>" required>
      </div>
      <div class="col-md-4">
        <label>Remarks</label>
        <input type="text" name="remarks" class="form-control">
      </div>
    </div>

    <ul class="nav nav-tabs no-print" id="tillTab" role="tablist">
      <?php for ($i = 1; $i <= 5; $i++): ?>
        <li class="nav-item" role="presentation">
          <button class="nav-link <?= $i === 1 ? 'active' : '' ?>" id="till<?= $i ?>-tab" data-bs-toggle="tab" data-bs-target="#till<?= $i ?>" type="button" role="tab">Till <?= $i ?></button>
        </li>
      <?php endfor; ?>
    </ul>

    <div class="tab-content border border-top-0 p-3 bg-white" id="tillTabContent">
      <?php for ($i = 1; $i <= 5; $i++): ?>
        <div class="tab-pane fade <?= $i === 1 ? 'show active' : '' ?>" id="till<?= $i ?>" role="tabpanel">
          <div class="card-header">Till <?= $i ?></div>
          <div class="card-body small p-2">
            <div class="row g-2">
              <div class="col-md-2"><label>Batch No.</label><input type="text" name="batch_<?= $i ?>" class="form-control"></div>
              <div class="col-md-2"><label>Cashier</label>
                <select name="cashier_<?= $i ?>" class="form-select">
                  <option value="">-- Select --</option>
                  <option>Charity</option><option>Eunice</option><option>Dorothy</option><option>Faith</option><option>Gladys</option>
                </select>
              </div>
              <div class="col-md-2"><label>Register</label><input type="text" name="register_<?= $i ?>" class="form-control"></div>
              <div class="col-md-2"><label>Opening</label><input type="number" step="0.01" name="opening_<?= $i ?>" class="form-control"></div>
              <div class="col-md-2"><label>Drop 1</label><input type="number" step="0.01" name="drop1_<?= $i ?>" class="form-control drop<?= $i ?>"></div>
              <div class="col-md-2"><label>Drop 2</label><input type="number" step="0.01" name="drop2_<?= $i ?>" class="form-control drop<?= $i ?>"></div>
              <div class="col-md-2"><label>Drop 3</label><input type="number" step="0.01" name="drop3_<?= $i ?>" class="form-control drop<?= $i ?>"></div>
              <div class="col-md-1"><label>1000s</label><input type="number" step="0.01" name="note_1000_<?= $i ?>" class="form-control denom<?= $i ?>"></div>
              <div class="col-md-1"><label>500s</label><input type="number" step="0.01" name="note_500_<?= $i ?>" class="form-control denom<?= $i ?>"></div>
              <div class="col-md-1"><label>200s</label><input type="number" step="0.01" name="note_200_<?= $i ?>" class="form-control denom<?= $i ?>"></div>
              <div class="col-md-1"><label>100s</label><input type="number" step="0.01" name="note_100_<?= $i ?>" class="form-control denom<?= $i ?>"></div>
              <div class="col-md-1"><label>50s</label><input type="number" step="0.01" name="note_50_<?= $i ?>" class="form-control denom<?= $i ?>"></div>
              <div class="col-md-1"><label>Coins</label><input type="number" step="0.01" name="coins_<?= $i ?>" class="form-control coins<?= $i ?>"></div>
              <div class="col-md-2"><label>MPESA</label><input type="number" step="0.01" name="mpesa_<?= $i ?>" class="form-control mpesa<?= $i ?>"></div>
              <div class="col-md-2"><label>VISA</label><input type="number" step="0.01" name="visa_<?= $i ?>" class="form-control visa<?= $i ?>"></div>
              <div class="col-md-2"><label>Over/Short</label><input type="text" name="over_short_<?= $i ?>" class="form-control"></div>
              <div class="col-md-2"><label>Signature</label><input type="text" name="signature_<?= $i ?>" class="form-control"></div>
            </div>
            <div class="row mt-2">
              <div class="col"><label>Total Drop</label><input type="text" class="form-control total-drop<?= $i ?>" readonly></div>
              <div class="col"><label>TT Notes</label><input type="text" class="form-control tt-notes<?= $i ?>" readonly></div>
              <div class="col"><label>Total Cash</label><input type="text" class="form-control total-cash<?= $i ?>" readonly></div>
              <div class="col"><label>Total All</label><input type="text" class="form-control total-all<?= $i ?>" readonly></div>
            </div>
          </div>
        </div>
      <?php endfor; ?>
    </div>

    <div class="text-end mt-3">
      <button type="submit" class="btn btn-success btn-sm">📂 Save Report</button>
      <button type="button" class="btn btn-secondary btn-sm" onclick="window.print()">🖨️ Print</button>
    </div>
  </form>

  <div class="container mt-4">
    <h6>🔍 Till Summary Table (Live)</h6>
    <div class="table-responsive" style="max-height: 300px; overflow-y: auto;">
      <table class="table table-sm table-bordered table-striped text-center align-middle" id="summaryTable">
        <thead class="table-light sticky-top">
          <tr>
            <th>Till</th>
            <th>Batch No</th>
            <th>Cashier</th>
            <th>Register</th>
            <th>Coins</th>
            <th>Total Notes</th>
            <th>Total Cash</th>
            <th>MPESA</th>
            <th>VISA</th>
            <th>Grand Total</th>
          </tr>
        </thead>
        <tbody id="summaryBody"></tbody>
        <tfoot class="table-primary sticky-bottom">
          <tr>
            <th colspan="4" class="text-end">TOTALS:</th>
            <th id="sumCoins">0.00</th>
            <th id="sumNotes">0.00</th>
            <th id="sumCash">0.00</th>
            <th id="sumMpesa">0.00</th>
            <th id="sumVisa">0.00</th>
            <th id="sumTotal">0.00</th>
          </tr>
        </tfoot>
      </table>
    </div>
  </div>
</div>

<script>
function formatCurrency(val) {
  return parseFloat(val || 0).toLocaleString('en-KE', { minimumFractionDigits: 2 });
}

function calculateTotals() {
  let grandDrop = 0, grandCash = 0, grandMpesa = 0, grandVisa = 0, grandAll = 0;
  let sumCoins = 0, sumNotes = 0, sumTotalCash = 0, sumMpesa = 0, sumVisa = 0, sumTotal = 0;
  const summaryBody = document.getElementById('summaryBody');
  summaryBody.innerHTML = '';

  for (let i = 1; i <= 5; i++) {
    let dropTotal = 0;
    document.querySelectorAll(`.drop${i}`).forEach(el => dropTotal += parseFloat(el.value) || 0);
    document.querySelector(`.total-drop${i}`).value = formatCurrency(dropTotal);

    let d1000 = parseFloat(document.querySelector(`[name='note_1000_${i}']`)?.value) || 0;
    let d500 = parseFloat(document.querySelector(`[name='note_500_${i}']`)?.value) || 0;
    let d200 = parseFloat(document.querySelector(`[name='note_200_${i}']`)?.value) || 0;
    let d100 = parseFloat(document.querySelector(`[name='note_100_${i}']`)?.value) || 0;
    let d50 = parseFloat(document.querySelector(`[name='note_50_${i}']`)?.value) || 0;
    let coins = parseFloat(document.querySelector(`.coins${i}`)?.value) || 0;
    let ttNotes = d1000 + d500 + d200 + d100 + d50;
    let totalCash = ttNotes + coins + dropTotal;

    document.querySelector(`.tt-notes${i}`).value = formatCurrency(ttNotes);
    document.querySelector(`.total-cash${i}`).value = formatCurrency(totalCash);

    let mpesa = parseFloat(document.querySelector(`.mpesa${i}`)?.value) || 0;
    let visa = parseFloat(document.querySelector(`.visa${i}`)?.value) || 0;
    let totalAll = totalCash + mpesa + visa;
    document.querySelector(`.total-all${i}`).value = formatCurrency(totalAll);

    grandDrop += dropTotal;
    grandCash += totalCash;
    grandMpesa += mpesa;
    grandVisa += visa;
    grandAll += totalAll;

    // Live summary
    if (dropTotal > 0 || ttNotes > 0 || coins > 0 || mpesa > 0 || visa > 0) {
      let batch = document.querySelector(`[name='batch_${i}']`)?.value || '-';
      let cashier = document.querySelector(`[name='cashier_${i}']`)?.value || '-';
      let register = document.querySelector(`[name='register_${i}']`)?.value || '-';
      summaryBody.innerHTML += `
        <tr>
          <td>Till ${i}</td>
          <td>${batch}</td>
          <td>${cashier}</td>
          <td>${register}</td>
          <td>${formatCurrency(coins)}</td>
          <td>${formatCurrency(ttNotes)}</td>
          <td>${formatCurrency(totalCash)}</td>
          <td>${formatCurrency(mpesa)}</td>
          <td>${formatCurrency(visa)}</td>
          <td>${formatCurrency(totalAll)}</td>
        </tr>
      `;
      sumCoins += coins;
      sumNotes += ttNotes;
      sumTotalCash += totalCash;
      sumMpesa += mpesa;
      sumVisa += visa;
      sumTotal += totalAll;
    }
  }

  document.getElementById('grandDrop').innerText = formatCurrency(grandDrop);
  document.getElementById('grandCash').innerText = formatCurrency(grandCash);
  document.getElementById('grandMpesa').innerText = formatCurrency(grandMpesa);
  document.getElementById('grandVisa').innerText = formatCurrency(grandVisa);
  document.getElementById('grandAll').innerText = formatCurrency(grandAll);

  document.getElementById('sumCoins').innerText = formatCurrency(sumCoins);
  document.getElementById('sumNotes').innerText = formatCurrency(sumNotes);
  document.getElementById('sumCash').innerText = formatCurrency(sumTotalCash);
  document.getElementById('sumMpesa').innerText = formatCurrency(sumMpesa);
  document.getElementById('sumVisa').innerText = formatCurrency(sumVisa);
  document.getElementById('sumTotal').innerText = formatCurrency(sumTotal);
}

document.querySelectorAll('input, select').forEach(el => {
  el.addEventListener('input', calculateTotals);
});

calculateTotals();
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
