<?php
session_start();
require_once '../../config/db.php';
include '../../includes/layout2.php';

if (empty($_SESSION['csrf_token'])) $_SESSION['csrf_token'] = bin2hex(random_bytes(32));

$id = (int)($_GET['id'] ?? 0);
if (!$id) { header('Location: list.php'); exit; }

$h = $conn->prepare("
  SELECT scn.*,
         s.name AS supplier_name,
         COALESCE(i.invoice_number,'') AS invoice_number,
         b.branch_name,
         vsc.available AS scn_available,
         vgr.available AS grn_available
  FROM supplier_credit_notes scn
  JOIN suppliers s        ON s.id = scn.supplier_id
  LEFT JOIN invoices i    ON i.id = scn.invoice_id
  LEFT JOIN branches b    ON b.id = scn.branch_id
  LEFT JOIN v_supplier_credit_available vsc ON vsc.credit_note_id = scn.id AND scn.note_type='Credit Note'
  LEFT JOIN v_supplier_grn_available    vgr ON vgr.grn_id          = scn.id AND scn.note_type='Goods Return Note'
  WHERE scn.id = ?
");
$h->bind_param('i',$id); $h->execute(); $hdr = $h->get_result()->fetch_assoc(); $h->close();
if (!$hdr) { header('Location: list.php'); exit; }

$items = $conn->prepare("SELECT * FROM supplier_credit_note_items WHERE credit_note_id=? ORDER BY id");
$items->bind_param('i',$id); $items->execute(); $itres=$items->get_result();

$alloc = $conn->prepare("SELECT sca.*, inv.invoice_number FROM supplier_credit_allocations sca
                         JOIN invoices inv ON inv.id = sca.invoice_id
                         WHERE sca.credit_note_id=? ORDER BY sca.id DESC");
$alloc->bind_param('i',$id); $alloc->execute(); $alres=$alloc->get_result();

$grnMatchStmt = $conn->prepare("
  SELECT m.*, grn.credit_note_number AS grn_no, grn.credit_date, b.branch_name
  FROM supplier_grn_matches m
  JOIN supplier_credit_notes grn ON grn.id = m.grn_id
  LEFT JOIN branches b ON b.id = grn.branch_id
  WHERE m.credit_note_id = ?
  ORDER BY m.id DESC
");
$grnMatchStmt->bind_param('i',$id); $grnMatchStmt->execute(); $grnMatches=$grnMatchStmt->get_result();

$available = $hdr['note_type']==='Credit Note' ? (float)($hdr['scn_available'] ?? 0) : (float)($hdr['grn_available'] ?? 0);
?>
<div class="main-content">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h4 class="fw-bold text-primary"><i class="fas fa-file-invoice me-2"></i> View <?= htmlspecialchars($hdr['note_type']) ?></h4>
    <div class="d-flex gap-2">
      <?php if ($hdr['status']==='active'): ?>
        <?php if ($hdr['note_type']==='Credit Note'): ?>
          <button class="btn btn-success" data-bs-toggle="modal" data-bs-target="#matchGrnModal"><i class="fas fa-receipt me-1"></i> Match GRNs</button>
          <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#allocModal"><i class="fas fa-link me-1"></i> Allocate Credit</button>
        <?php endif; ?>
        <?php if (!empty($hdr['pdf_path'])): ?>
          <a class="btn btn-outline-primary" target="_blank" href="../../<?= htmlspecialchars($hdr['pdf_path']) ?>"><i class="fas fa-file-pdf me-1"></i> Download PDF</a>
        <?php endif; ?>
        <a class="btn btn-outline-danger" href="void.php?id=<?= $id ?>&csrf=<?= $_SESSION['csrf_token'] ?>" onclick="return confirm('Void this note?');"><i class="fas fa-ban me-1"></i> Void</a>
      <?php else: ?>
        <a class="btn btn-warning" href="void.php?id=<?= $id ?>&action=unvoid&csrf=<?= $_SESSION['csrf_token'] ?>" onclick="return confirm('Unvoid this note?');"><i class="fas fa-rotate-left me-1"></i> Unvoid</a>
      <?php endif; ?>
      <a class="btn btn-outline-secondary" href="list.php"><i class="fas fa-arrow-left me-1"></i> Back</a>
    </div>
  </div>

  <div class="card p-3 mb-3">
    <div class="row g-3">
      <div class="col-md-3"><strong>No:</strong> <?= htmlspecialchars($hdr['credit_note_number']) ?></div>
      <div class="col-md-3"><strong>Date:</strong> <?= htmlspecialchars($hdr['credit_date']) ?></div>
      <div class="col-md-3"><strong>Branch:</strong> <?= htmlspecialchars($hdr['branch_name'] ?? '—') ?></div>
      <div class="col-md-3"><strong>Supplier:</strong> <?= htmlspecialchars($hdr['supplier_name']) ?></div>
      <div class="col-md-3"><strong>Type:</strong> <?= htmlspecialchars($hdr['note_type']) ?></div>
      <div class="col-md-3"><strong>Status:</strong> <span class="badge bg-<?= $hdr['status']==='active'?'success':'secondary' ?>"><?= htmlspecialchars($hdr['status']) ?></span></div>
      <div class="col-md-3">
        <strong>Available:</strong>
        <?= number_format($available,2) ?>
        <?php if ($hdr['note_type']==='Credit Note'): ?>
          <span class="text-muted small">(after allocations & GRN matches)</span>
        <?php endif; ?>
      </div>
      <div class="col-md-3"><strong>Invoice:</strong> <?= htmlspecialchars($hdr['invoice_number'] ?: '—') ?></div>
      <div class="col-12"><strong>Reason:</strong> <?= htmlspecialchars($hdr['reason']) ?></div>
      <?php if (!empty($hdr['description_note'])): ?>
        <div class="col-12"><strong>Description:</strong> <?= htmlspecialchars($hdr['description_note']) ?></div>
      <?php endif; ?>
      <?php if (!empty($hdr['file_path'])): ?>
        <div class="col-12">
          <a class="btn btn-sm btn-outline-primary" target="_blank" href="../../<?= htmlspecialchars($hdr['file_path']) ?>"><i class="fas fa-file-pdf me-1"></i> View Attachment</a>
        </div>
      <?php endif; ?>
    </div>
  </div>

  <div class="card p-2 mb-3">
    <div class="table-responsive">
      <table class="table table-bordered align-middle">
        <thead class="table-light"><tr>
          <th>#</th><th>SKU</th><th>Item</th><th>Unit</th>
          <th class="text-end">Qty</th><th class="text-end">Price</th><th class="text-end">VAT %</th><th class="text-end">Total</th>
        </tr></thead>
        <tbody>
        <?php $n=1; $subtotal=0; $vat=0; $total=0; while($ln=$itres->fetch_assoc()):
          $subtotal+=(float)$ln['line_subtotal']; $vat+=(float)$ln['line_vat']; $total+=(float)$ln['line_total']; ?>
          <tr>
            <td><?= $n++ ?></td>
            <td><?= htmlspecialchars($ln['sku']) ?></td>
            <td><?= htmlspecialchars($ln['item_name']) ?></td>
            <td><?= htmlspecialchars($ln['unit']) ?></td>
            <td class="text-end"><?= number_format((float)$ln['qty'],3) ?></td>
            <td class="text-end"><?= number_format((float)$ln['unit_price'],4) ?></td>
            <td class="text-end"><?= number_format((float)$ln['vat_rate'],2) ?></td>
            <td class="text-end"><?= number_format((float)$ln['line_total'],2) ?></td>
          </tr>
        <?php endwhile; ?>
        </tbody>
        <tfoot>
          <tr><th colspan="7" class="text-end">Subtotal</th><th class="text-end"><?= number_format($subtotal,2) ?></th></tr>
          <tr><th colspan="7" class="text-end">VAT</th><th class="text-end"><?= number_format($vat,2) ?></th></tr>
          <tr><th colspan="7" class="text-end">Total</th><th class="text-end"><?= number_format($total,2) ?></th></tr>
        </tfoot>
      </table>
    </div>
  </div>

  <?php if ($hdr['note_type']==='Credit Note'): ?>
  <div class="card p-2 mb-3">
    <h6 class="px-2 pt-2">Allocations (to invoices)</h6>
    <div class="table-responsive">
      <table class="table table-sm table-striped mb-0">
        <thead class="table-light"><tr><th>#</th><th>Invoice</th><th class="text-end">Amount</th><th>Date</th></tr></thead>
        <tbody>
          <?php $i=1; while($a=$alres->fetch_assoc()): ?>
          <tr><td><?= $i++ ?></td><td><?= htmlspecialchars($a['invoice_number']) ?></td><td class="text-end"><?= number_format((float)$a['allocated_amount'],2) ?></td><td><?= htmlspecialchars($a['created_at']) ?></td></tr>
          <?php endwhile; if($i===1): ?><tr><td colspan="4" class="text-center text-muted">No allocations yet.</td></tr><?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>

  <div class="card p-2 mb-3">
    <h6 class="px-2 pt-2">Matched GRNs</h6>
    <div class="table-responsive">
      <table class="table table-sm table-striped mb-0">
        <thead class="table-light"><tr><th>#</th><th>GRN #</th><th>Date</th><th>Branch</th><th class="text-end">Matched Amount</th><th>Matched On</th></tr></thead>
        <tbody>
          <?php $j=1; while($m=$grnMatches->fetch_assoc()): ?>
            <tr>
              <td><?= $j++ ?></td>
              <td><?= htmlspecialchars($m['grn_no']) ?></td>
              <td><?= htmlspecialchars($m['credit_date']) ?></td>
              <td><?= htmlspecialchars($m['branch_name'] ?? '—') ?></td>
              <td class="text-end"><?= number_format((float)$m['matched_amount'],2) ?></td>
              <td><?= htmlspecialchars($m['created_at']) ?></td>
            </tr>
          <?php endwhile; if($j===1): ?><tr><td colspan="6" class="text-center text-muted">No matches yet.</td></tr><?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
  <?php endif; ?>

  <!-- Upload Signed Scan step (moves to awaiting_finance) -->
  <?php if ($hdr['status']==='active' && ($hdr['workflow_state']==='awaiting_upload' || empty($hdr['signed_scan_path']))): ?>
  <div class="card p-3 mb-3">
    <h6 class="mb-2"><i class="fas fa-upload me-1"></i> Upload Signed Copies (Store & Supplier)</h6>
    <form action="upload_signed.php" method="post" enctype="multipart/form-data" class="row g-2">
      <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">
      <input type="hidden" name="credit_note_id" value="<?= (int)$id ?>">
      <div class="col-md-8">
        <input type="file" name="signed_scan" class="form-control" accept=".pdf,.jpg,.jpeg,.png" required>
        <div class="form-text">Scan both signed copies and upload as one PDF (preferred) or image.</div>
      </div>
      <div class="col-md-4 text-end">
        <button class="btn btn-primary"><i class="fas fa-cloud-upload-alt me-1"></i> Upload & Continue</button>
      </div>
    </form>
  </div>
  <?php elseif (!empty($hdr['signed_scan_path'])): ?>
  <div class="card p-3 mb-3">
    <h6 class="mb-2">Signed Copy</h6>
    <a class="btn btn-outline-primary btn-sm" target="_blank" href="../../<?= htmlspecialchars($hdr['signed_scan_path']) ?>"><i class="fas fa-file me-1"></i> View Signed Scan</a>
    <span class="text-muted ms-2 small">Uploaded: <?= htmlspecialchars($hdr['signed_scan_uploaded_at'] ?? '') ?></span>
  </div>
  <?php endif; ?>
</div>

<!-- Allocate Modal -->
<div class="modal fade" id="allocModal" tabindex="-1">
  <div class="modal-dialog modal-lg modal-dialog-scrollable">
    <div class="modal-content">
      <form method="post" action="allocate_save.php" class="p-0">
        <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">
        <input type="hidden" name="credit_note_id" value="<?= $id ?>">
        <div class="modal-header">
          <h5 class="modal-title">Allocate Credit — Available: <span id="allocAvail"><?= number_format((float)($hdr['scn_available'] ?? 0),2) ?></span></h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" ></button>
        </div>
        <div class="modal-body">
          <div class="table-responsive">
            <table class="table table-sm table-bordered align-middle">
              <thead class="table-light"><tr>
                <th>Invoice</th><th class="text-end">Total</th><th class="text-end">Balance</th><th class="text-end" style="width:160px;">Allocate</th>
              </tr></thead>
              <tbody id="alloc_rows"></tbody>
            </table>
          </div>
        </div>
        <div class="modal-footer">
          <button class="btn btn-primary"><i class="fas fa-save me-1"></i> Save Allocation</button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- Match GRNs Modal -->
<div class="modal fade" id="matchGrnModal" tabindex="-1">
  <div class="modal-dialog modal-lg modal-dialog-scrollable">
    <div class="modal-content">
      <form method="post" action="match_grns_save.php" class="p-0">
        <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">
        <input type="hidden" name="credit_note_id" value="<?= (int)$id ?>">
        <div class="modal-header">
          <h5 class="modal-title">Match Goods Return Notes to this Credit</h5>
          <button class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body">
          <div class="alert alert-info p-2">
            <div><strong>Credit Note:</strong> <?= htmlspecialchars($hdr['credit_note_number']) ?> |
              <strong>Available:</strong> <span id="scnAvail">loading…</span></div>
          </div>
          <div class="table-responsive">
            <table class="table table-sm table-bordered align-middle">
              <thead class="table-light">
                <tr>
                  <th>GRN #</th>
                  <th>Date</th>
                  <th>Branch</th>
                  <th>Reason</th>
                  <th class="text-end">GRN Amount</th>
                  <th class="text-end">Available</th>
                  <th class="text-end" style="width:160px;">Match Amount</th>
                </tr>
              </thead>
              <tbody id="grnRows"></tbody>
            </table>
          </div>
        </div>
        <div class="modal-footer">
          <button class="btn btn-primary"><i class="fas fa-save me-1"></i> Save Matches</button>
        </div>
      </form>
    </div>
  </div>
</div>

<script>
document.addEventListener('shown.bs.modal', async (e)=>{
  if(e.target.id==='allocModal'){
    const res = await fetch('fetch_invoices.php?supplier_id=<?= (int)$hdr['supplier_id'] ?>');
    const data = await res.json();
    const body = document.getElementById('alloc_rows'); body.innerHTML='';
    data.forEach(inv=>{
      const tr=document.createElement('tr');
      const bal=Number(inv.balance||0);
      tr.innerHTML = `
        <td>${inv.invoice_number}<div class="text-muted small">${inv.invoice_date}</div><input type="hidden" name="invoice_id[]" value="${inv.id}"></td>
        <td class="text-end">${Number(inv.total_amount).toFixed(2)}</td>
        <td class="text-end">${bal.toFixed(2)}</td>
        <td class="text-end"><input name="alloc_amount[]" type="number" step="0.01" min="0" max="${bal.toFixed(2)}" class="form-control form-control-sm text-end" placeholder="0.00"></td>`;
      body.appendChild(tr);
    });
  }
  if(e.target.id==='matchGrnModal'){
    const a = await (await fetch('scn_available.php?id=<?= (int)$id ?>')).json();
    document.getElementById('scnAvail').textContent = Number(a.available||0).toFixed(2);
    const res = await fetch('fetch_grns.php?supplier_id=<?= (int)$hdr["supplier_id"] ?>');
    const rows = await res.json();
    const body = document.getElementById('grnRows'); body.innerHTML='';
    rows.forEach(r=>{
      const tr=document.createElement('tr');
      tr.innerHTML = `
        <td>${r.credit_note_number}<input type="hidden" name="grn_id[]" value="${r.grn_id}"></td>
        <td>${r.credit_date}</td>
        <td>${r.branch_name||r.branch_id||''}</td>
        <td>${r.reason||''}</td>
        <td class="text-end">${Number(r.amount).toFixed(2)}</td>
        <td class="text-end">${Number(r.available).toFixed(2)}</td>
        <td class="text-end"><input name="match_amount[]" type="number" step="0.01" min="0" max="${Number(r.available).toFixed(2)}" class="form-control form-control-sm text-end" placeholder="0.00"></td>
      `;
      body.appendChild(tr);
    });
  }
});
</script>
