<?php
session_start();
require_once '../../config/db.php';
include '../../includes/layout2.php';

if (empty($_SESSION['csrf_token'])) $_SESSION['csrf_token'] = bin2hex(random_bytes(32));

$supplier_id = isset($_GET['supplier_id']) ? (int)$_GET['supplier_id'] : 0;
$where = "v.status='active' AND v.available > 0";
if ($supplier_id) $where .= " AND v.supplier_id={$supplier_id}";

$sql = "
  SELECT v.*, s.name AS supplier_name, b.branch_name
  FROM v_supplier_grn_available v
  JOIN suppliers s ON s.id = v.supplier_id
  LEFT JOIN branches b ON b.id = v.branch_id
  WHERE $where
  ORDER BY v.credit_date DESC, v.grn_id DESC
";
$rows = $conn->query($sql);
?>
<div class="main-content">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h4 class="fw-bold text-primary"><i class="fas fa-cash-register me-2"></i> Payment Management</h4>
  </div>

  <div class="card p-2">
    <div class="table-responsive">
      <table class="table table-sm table-bordered align-middle">
        <thead class="table-light">
          <tr>
            <th>GRN #</th><th>Date</th><th>Supplier</th><th>Branch</th>
            <th class="text-end">Amount</th><th class="text-end">Available</th>
            <th style="width:360px;">Actions</th>
          </tr>
        </thead>
        <tbody>
        <?php if($rows && $rows->num_rows): while($r=$rows->fetch_assoc()): ?>
          <tr>
            <td><?= htmlspecialchars($r['credit_note_number']) ?></td>
            <td><?= htmlspecialchars($r['credit_date']) ?></td>
            <td><?= htmlspecialchars($r['supplier_name']) ?></td>
            <td><?= htmlspecialchars($r['branch_name'] ?? '—') ?></td>
            <td class="text-end"><?= number_format((float)$r['amount'],2) ?></td>
            <td class="text-end"><?= number_format((float)$r['available'],2) ?></td>
            <td>
              <a class="btn btn-sm btn-outline-primary" href="view.php?id=<?= (int)$r['grn_id'] ?>">Use Supplier Credit</a>
              <button class="btn btn-sm btn-outline-success" data-bs-toggle="modal" data-bs-target="#deductModal"
                      data-grn="<?= (int)$r['grn_id'] ?>" data-supplier="<?= (int)$r['supplier_id'] ?>"
                      data-available="<?= (float)$r['available'] ?>">Deduct from Invoice</button>
              <button class="btn btn-sm btn-outline-warning" data-bs-toggle="modal" data-bs-target="#goodsModal"
                      data-grn="<?= (int)$r['grn_id'] ?>" data-available="<?= (float)$r['available'] ?>">Compensate with Goods</button>
            </td>
          </tr>
        <?php endwhile; else: ?>
          <tr><td colspan="7" class="text-center text-muted">Nothing pending.</td></tr>
        <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<!-- Deduct from Invoice Modal -->
<div class="modal fade" id="deductModal" tabindex="-1">
  <div class="modal-dialog modal-lg modal-dialog-scrollable">
    <div class="modal-content">
      <form method="post" action="settle_deduct_invoice.php" class="p-0">
        <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">
        <input type="hidden" name="grn_id" id="ded_grn_id">
        <div class="modal-header">
          <h5 class="modal-title">Deduct from Invoice</h5>
          <button class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body">
          <div class="alert alert-info p-2"><strong>Available:</strong> <span id="ded_available">0.00</span></div>
          <div class="row g-2">
            <div class="col-md-4">
              <label class="small">Amount to Deduct</label>
              <input name="amount" id="ded_amount" type="number" step="0.01" min="0" class="form-control" required>
            </div>
            <div class="col-md-8">
              <label class="small">Invoice</label>
              <select name="invoice_id" id="ded_invoice" class="form-select" required></select>
              <div class="form-text">Creates an internal SCN, auto-matches to this GRN, and allocates to the invoice.</div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <button class="btn btn-success"><i class="fas fa-check me-1"></i> Confirm Deduction</button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- Compensate with Goods Modal -->
<div class="modal fade" id="goodsModal" tabindex="-1">
  <div class="modal-dialog">
    <div class="modal-content">
      <form method="post" action="settle_goods_comp.php" class="p-0">
        <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">
        <input type="hidden" name="grn_id" id="goods_grn_id">
        <div class="modal-header">
          <h5 class="modal-title">Compensate with Goods</h5>
          <button class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body">
          <div class="alert alert-warning p-2"><strong>Available:</strong> <span id="goods_available">0.00</span></div>
          <div class="mb-2">
            <label class="small">Compensation Amount</label>
            <input name="amount" id="goods_amount" type="number" step="0.01" min="0" class="form-control" required>
          </div>
          <div class="form-check">
            <input class="form-check-input" type="checkbox" value="1" id="mirror_items" name="mirror_items">
            <label class="form-check-label small" for="mirror_items">Also bring back GRN items into stock (same qty, same branch)</label>
          </div>
          <div class="mt-2">
            <label class="small">Notes (optional)</label>
            <input name="notes" class="form-control" placeholder="e.g., Replacement delivery ref, LR#">
          </div>
        </div>
        <div class="modal-footer">
          <button class="btn btn-warning"><i class="fas fa-box me-1"></i> Confirm Compensation</button>
        </div>
      </form>
    </div>
  </div>
</div>

<script>
const deductModal = document.getElementById('deductModal');
deductModal.addEventListener('show.bs.modal', async (e)=>{
  const btn = e.relatedTarget;
  const grnId = btn.getAttribute('data-grn');
  const supplierId = btn.getAttribute('data-supplier');
  const available = parseFloat(btn.getAttribute('data-available')||0);
  document.getElementById('ded_grn_id').value = grnId;
  document.getElementById('ded_available').textContent = available.toFixed(2);
  const amt = document.getElementById('ded_amount'); amt.value = available.toFixed(2); amt.max = available.toFixed(2);

  const res = await fetch('fetch_invoices.php?supplier_id='+supplierId);
  const invs = await res.json();
  const sel = document.getElementById('ded_invoice'); sel.innerHTML='';
  invs.forEach(i=>{
    const opt = document.createElement('option');
    opt.value = i.id;
    opt.textContent = `${i.invoice_number} (${i.invoice_date}) - Bal: ${Number(i.balance||0).toFixed(2)}`;
    sel.appendChild(opt);
  });
});

const goodsModal = document.getElementById('goodsModal');
goodsModal.addEventListener('show.bs.modal', (e)=>{
  const btn = e.relatedTarget;
  const grnId = btn.getAttribute('data-grn');
  const available = parseFloat(btn.getAttribute('data-available')||0);
  document.getElementById('goods_grn_id').value = grnId;
  document.getElementById('goods_available').textContent = available.toFixed(2);
  const amt = document.getElementById('goods_amount'); amt.value = available.toFixed(2); amt.max = available.toFixed(2);
});
</script>
