<?php
// FILE: modules/returns/search_items.php
session_start();
require_once '../../config/db.php';
header('Content-Type: application/json');

$q = trim($_GET['q'] ?? '');
$barcode = trim($_GET['barcode'] ?? '');
$rows = [];

$sql = "SELECT id, sku, barcode, name, default_unit AS unit, cost_price, vat_rate
        FROM items
        WHERE 1=1";
$params=[]; $types='';

if ($barcode !== '') { $sql .= " AND barcode = ?"; $params[]=$barcode; $types.='s'; }
if ($q !== '') { $sql .= " AND (sku LIKE CONCAT('%',?,'%') OR name LIKE CONCAT('%',?,'%'))"; $params[]=$q; $params[]=$q; $types.='ss'; }
$sql .= " ORDER BY name LIMIT 20";

$st = $conn->prepare($sql);
if ($types) $st->bind_param($types, ...$params);
$st->execute(); $res = $st->get_result();
while ($r = $res->fetch_assoc()) {
  $rows[] = [
    'id'=>(int)$r['id'],
    'sku'=>$r['sku'],
    'barcode'=>$r['barcode'],
    'name'=>$r['name'],
    'unit'=>$r['unit'] ?? 'pcs',
    'cost_price'=> (float)($r['cost_price'] ?? 0),
    'vat_rate'=> (float)($r['vat_rate'] ?? 16.00),
  ];
}
echo json_encode($rows);
