<?php
session_start();
require_once '../../config/db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = (int) $_POST['payment_id'];
    $status = $_POST['cheque_status'];

    if (!in_array($status, ['Pending', 'Cleared', 'Bounced', 'Cancelled'])) {
        $_SESSION['error'] = "Invalid status.";
        header("Location: reconcile_cheques.php");
        exit;
    }

    $stmt = $conn->prepare("UPDATE payments SET cheque_status = ?, updated_at = NOW(), updated_by = ? WHERE id = ?");
    $stmt->bind_param("sii", $status, $_SESSION['user_id'], $id);
    
    if ($stmt->execute()) {
        $_SESSION['success'] = "Cheque status updated successfully.";
    } else {
        $_SESSION['error'] = "Failed to update status.";
    }

    header("Location: reconcile_cheques.php");
    exit;
}
