<?php
session_start();
require_once '../../config/db.php';
include '../../includes/layout2.php';

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) {
    $_SESSION['error'] = "Invalid transaction.";
    header("Location: list.php");
    exit;
}

$stmt = $conn->prepare("SELECT reference_no, support_doc, support_note FROM petty_cash_transactions WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$txn = $result->fetch_assoc();

if (!$txn) {
    $_SESSION['error'] = "Transaction not found.";
    header("Location: list.php");
    exit;
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Upload Supporting Document</title>
    <link href="../../assets/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="p-4">
<div class="container">
    <h4 class="mb-3">Upload or Enter Payment Support for Ref: <?= htmlspecialchars($txn['reference_no']) ?></h4>

    <?php if (isset($_SESSION['error'])): ?>
        <div class="alert alert-danger"><?= $_SESSION['error']; unset($_SESSION['error']); ?></div>
    <?php elseif (isset($_SESSION['success'])): ?>
        <div class="alert alert-success"><?= $_SESSION['success']; unset($_SESSION['success']); ?></div>
    <?php endif; ?>

    <form action="save_support.php" method="POST" enctype="multipart/form-data" id="supportForm">
        <input type="hidden" name="id" value="<?= $id ?>">

        <div class="mb-3">
            <label class="form-label">Upload Supporting Document (PDF/Image)</label>
            <input type="file" name="support_doc" id="support_doc" accept=".pdf,.jpg,.jpeg,.png" class="form-control">
        </div>

        <?php if (!empty($txn['support_doc'])): ?>
            <div class="mb-2">
                <a href="<?= htmlspecialchars($txn['support_doc']) ?>" target="_blank" class="btn btn-sm btn-outline-secondary">View Existing File</a>
            </div>
        <?php endif; ?>

        <div class="mb-3">
            <label class="form-label">Or Enter Payment Details (if no document)</label>
            <textarea name="support_note" id="support_note" rows="4" class="form-control"><?= htmlspecialchars($txn['support_note'] ?? '') ?></textarea>
        </div>

        <div class="mb-3">
            <label class="form-label">Payout Number <span class="text-danger">*</span></label>
            <input type="text" name="payout_number" id="payout_number" class="form-control" required>
        </div>

        <div class="mb-3">
            <label class="form-label">Till Number <span class="text-danger">*</span></label>
            <input type="text" name="till_number" id="till_number" class="form-control" required>
        </div>

        <button type="submit" class="btn btn-primary">Submit & Approve</button>
        <a href="list.php" class="btn btn-secondary">Cancel</a>
    </form>
</div>

<script>
document.getElementById('supportForm').addEventListener('submit', function (e) {
    const file = document.getElementById('support_doc').value.trim();
    const note = document.getElementById('support_note').value.trim();
    const payout = document.getElementById('payout_number').value.trim();
    const till = document.getElementById('till_number').value.trim();

    if (!file && !note) {
        alert("Please upload a document or enter payment support details.");
        e.preventDefault();
        return;
    }

    if (!payout || !till) {
        alert("Please enter both Payout Number and Till Number.");
        e.preventDefault();
        return;
    }
});
</script>

</body>
</html>
