<?php
session_start();
require_once '../../config/db.php';

$merchandisers = $conn->query("
    SELECT m.*, s.name AS supplier_name 
    FROM merchandisers m 
    JOIN suppliers s ON m.supplier_id = s.id 
    ORDER BY m.full_name ASC
");

include '../../includes/layout2.php';
?>

<div class="main-content">
  <h4 class="fw-bold mb-4 text-primary"><i class="fas fa-users"></i> Merchandiser Directory</h4>

  <div class="card p-3 shadow-sm">
    <div class="d-flex justify-content-between mb-3">
      <form class="d-flex">
        <input type="search" class="form-control me-2" placeholder="Search merchandiser...">
      </form>
      <a href="add_merchandiser.php" class="btn btn-primary"><i class="fas fa-plus-circle me-1"></i> Add New</a>
    </div>

    <div class="table-responsive">
      <table class="table table-bordered table-hover align-middle">
        <thead class="table-dark">
          <tr>
            <th>#</th>
            <th>Full Name</th>
            <th>ID Number</th>
            <th>Phone</th>
            <th>Supplier</th>
            <th>Status</th>
            <th>Created</th>
            <th>Action</th>
          </tr>
        </thead>
        <tbody>
          <?php $i = 1; while ($m = $merchandisers->fetch_assoc()): ?>
            <tr>
              <td><?= $i++ ?></td>
              <td><?= htmlspecialchars($m['full_name']) ?></td>
              <td><?= htmlspecialchars($m['id_number']) ?></td>
              <td><?= htmlspecialchars($m['phone']) ?></td>
              <td><?= htmlspecialchars($m['supplier_name']) ?></td>
              <td>
                <span class="badge bg-<?= $m['status'] === 'Active' ? 'success' : 'secondary' ?>">
                  <?= $m['status'] ?>
                </span>
              </td>
              <td><?= date('d M Y', strtotime($m['created_at'])) ?></td>
              <td>
                <a href="edit_merchandiser.php?id=<?= $m['id'] ?>" class="btn btn-sm btn-warning">
                  <i class="fas fa-edit"></i> Edit
                </a>
              </td>
            </tr>
          <?php endwhile; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
