<?php
session_start();
require_once '../../config/db.php';

if (empty($_SESSION['csrf_token'])) {
  $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

$suppliers = $conn->query("SELECT id, name FROM suppliers ORDER BY name ASC");
$branches  = $conn->query("SELECT id, branch_name FROM branches ORDER BY branch_name ASC");

include '../../includes/layout2.php';
?>

<div class="main-content">
  <h4 class="fw-bold mb-4 text-primary"><i class="fas fa-file-invoice"></i> Add New Supplier Invoice</h4>

  <!-- 🔔 Error Alert -->
  <?php if (isset($_SESSION['error'])): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
      <?= $_SESSION['error'] ?>
      <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php unset($_SESSION['error']); ?>
  <?php endif; ?>

  <form method="POST" action="save_invoice.php" enctype="multipart/form-data" class="card p-4 shadow-sm bg-white">
    <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">

    <!-- Supplier, Branch, Date -->
    <div class="row mb-3">
      <div class="col-md-4">
        <label class="form-label">Supplier</label>
        <select name="supplier_id" class="form-select" required>
          <option value="">-- Select Supplier --</option>
          <?php while ($s = $suppliers->fetch_assoc()): ?>
            <option value="<?= $s['id'] ?>"><?= htmlspecialchars($s['name']) ?></option>
          <?php endwhile; ?>
        </select>
      </div>

      <div class="col-md-4">
        <label class="form-label">Branch</label>
        <select name="branch_id" class="form-select" required>
          <option value="">-- Select Branch --</option>
          <?php while ($b = $branches->fetch_assoc()): ?>
            <option value="<?= $b['id'] ?>"><?= htmlspecialchars($b['branch_name']) ?></option>
          <?php endwhile; ?>
        </select>
      </div>

      <div class="col-md-4">
        <label class="form-label">Invoice Date</label>
        <input type="date" name="invoice_date" class="form-control" required value="<?= date('Y-m-d') ?>">
      </div>
    </div>

    <!-- Invoice Number, Amounts -->
    <div class="row mb-3">
      <div class="col-md-4">
        <label class="form-label">Invoice Number</label>
        <input type="text" name="invoice_number" class="form-control" required>
      </div>

      <div class="col-md-4">
        <label class="form-label">Total Invoice Amount</label>
        <input type="number" step="0.01" name="total_invoice_amount" id="invoiceAmount" class="form-control" required>
      </div>

      <div class="col-md-4">
        <label class="form-label">Zero-Rated Amount</label>
        <input type="number" step="0.01" name="zero_rated_amount" id="zeroRated" class="form-control">
      </div>
    </div>

    <!-- File Upload + VAT Type -->
    <div class="row mb-3">
      <div class="col-md-6">
        <label class="form-label">Invoice File (PDF)</label>
        <input type="file" name="invoice_file" class="form-control" accept=".pdf" required>
      </div>

      <div class="col-md-6">
        <label class="form-label">VAT Type</label><br>
        <div class="form-check form-check-inline">
          <input class="form-check-input" type="radio" name="vat_inclusion" id="vatInclusive" value="inclusive" checked>
          <label class="form-check-label" for="vatInclusive">Inclusive</label>
        </div>
        <div class="form-check form-check-inline">
          <input class="form-check-input" type="radio" name="vat_inclusion" id="vatExclusive" value="exclusive">
          <label class="form-check-label" for="vatExclusive">Exclusive</label>
        </div>
      </div>
    </div>

    <!-- Summary Cards -->
    <div class="row mb-4">
      <div class="col-md-3">
        <div class="card bg-light">
          <div class="card-body">
            <strong>VATable:</strong> <span id="vatableText" class="badge bg-primary">KSh 0.00</span>
          </div>
        </div>
      </div>
      <div class="col-md-3">
        <div class="card bg-light">
          <div class="card-body">
            <strong>VAT (16%):</strong> <span id="vatText" class="badge bg-warning text-dark">KSh 0.00</span>
          </div>
        </div>
      </div>
      <div class="col-md-3">
        <div class="card bg-light">
          <div class="card-body">
            <strong>Withholding (2%):</strong> <span id="whtText" class="badge bg-info text-dark">KSh 0.00</span>
          </div>
        </div>
      </div>
      <div class="col-md-3">
        <div class="card bg-success text-white">
          <div class="card-body">
            <strong>Total Payable:</strong> <span id="payableText">KSh 0.00</span>
          </div>
        </div>
      </div>
    </div>

    <!-- Hidden Calculation Fields -->
    <input type="hidden" name="vatable_amount" id="vatable">
    <input type="hidden" name="vat_amount" id="vat">
    <input type="hidden" name="withholding_tax" id="wht">
    <input type="hidden" name="total_payable" id="payable">
    <input type="hidden" name="total_with_vat" id="totalWithVat">

    <!-- Submit -->
    <div class="text-end">
      <button type="submit" class="btn btn-primary"><i class="fas fa-save me-1"></i> Save Invoice</button>
    </div>
  </form>
</div>

<!-- JS Auto-Calculation -->
<script>
function calculateTotals() {
  let total = parseFloat(document.getElementById("invoiceAmount").value) || 0;
  let zeroRated = parseFloat(document.getElementById("zeroRated").value) || 0;
  let isInclusive = document.getElementById("vatInclusive").checked;

  const vatRate = 0.16;
  const whtRate = 0.0;

  let vatable, vat, totalWithVat, wht, payable;

  if (isInclusive) {
    vatable = (total - zeroRated) / (1 + vatRate);
    vat = vatable * vatRate;
    totalWithVat = total;
  } else {
    vatable = total - zeroRated;
    vat = vatable * vatRate;
    totalWithVat = total + vat;
  }

  wht = vatable * whtRate;
  payable = totalWithVat - wht;

  document.getElementById("vatable").value = vatable.toFixed(2);
  document.getElementById("vat").value = vat.toFixed(2);
  document.getElementById("wht").value = wht.toFixed(2);
  document.getElementById("payable").value = payable.toFixed(2);
  document.getElementById("totalWithVat").value = totalWithVat.toFixed(2);

  document.getElementById("vatableText").textContent = "KSh " + vatable.toFixed(2);
  document.getElementById("vatText").textContent = "KSh " + vat.toFixed(2);
  document.getElementById("whtText").textContent = "KSh " + wht.toFixed(2);
  document.getElementById("payableText").textContent = "KSh " + payable.toFixed(2);
}

document.getElementById("invoiceAmount").addEventListener("input", calculateTotals);
document.getElementById("zeroRated").addEventListener("input", calculateTotals);
document.getElementById("vatInclusive").addEventListener("change", calculateTotals);
document.getElementById("vatExclusive").addEventListener("change", calculateTotals);
</script>
<?php include '../../includes/footer.php'; ?>
