<?php
session_start();
require_once '../../config/db.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: ../../login.php");
    exit();
}

$current_user = $_SESSION['username'] ?? '';
$current_role = $_SESSION['role'] ?? 'User';
$current_branch = $_SESSION['branch_id'] ?? 0;

// Generate CSRF token
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

$vehicle_id = isset($_GET['vehicle_id']) ? intval($_GET['vehicle_id']) : 0;
if ($vehicle_id <= 0) {
    $_SESSION['error'] = "Invalid vehicle selected.";
    header("Location: list_vehicles.php");
    exit();
}

// Fetch vehicle
$stmt = $conn->prepare("SELECT * FROM vehicles WHERE id = ?");
$stmt->bind_param("i", $vehicle_id);
$stmt->execute();
$vehicle = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$vehicle) {
    $_SESSION['error'] = "Vehicle not found.";
    header("Location: list_vehicles.php");
    exit();
}

// Fetch eligible drivers
$driver_query = "SELECT id, full_name FROM drivers WHERE status = 'Active'";
if ($current_role !== 'Admin') {
    $driver_query .= " AND branch_id = $current_branch";
}
$driver_query .= " ORDER BY full_name ASC";
$drivers = $conn->query($driver_query);
include_once '../../includes/layout2.php';

?>

<div class="main-content p-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h4 class="fw-bold text-primary"><i class="fas fa-user-tag me-2"></i> Assign Driver - <?= htmlspecialchars($vehicle['plate_number']) ?></h4>
        <a href="list_vehicles.php" class="btn btn-secondary"><i class="fas fa-arrow-left"></i> Back to Fleet</a>
    </div>

    <?php if (isset($_SESSION['error'])): ?>
        <div class="alert alert-danger"><?= $_SESSION['error']; unset($_SESSION['error']); ?></div>
    <?php endif; ?>

    <form method="POST" action="save_driver_assignment.php" class="card shadow p-4">
        <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">
        <input type="hidden" name="vehicle_id" value="<?= $vehicle_id ?>">

        <div class="mb-3">
            <label class="form-label">Select Driver</label>
            <select name="driver_id" class="form-select select2">
                <option value="">-- Unassign Driver --</option>
                <?php while ($d = $drivers->fetch_assoc()): ?>
                    <option value="<?= $d['id'] ?>" <?= $vehicle['assigned_driver_id'] == $d['id'] ? 'selected' : '' ?>>
                        <?= htmlspecialchars($d['full_name']) ?>
                    </option>
                <?php endwhile; ?>
            </select>
        </div>

        <div class="mt-4">
            <button type="submit" class="btn btn-primary px-4"><i class="fas fa-save me-1"></i> Save Assignment</button>
        </div>
    </form>
</div>

<?php include_once '../../includes/footer.php'; ?>

<!-- Select2 -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    $(document).ready(function () {
        $('.select2').select2({ width: '100%' });
    });
</script>
