<?php
session_start();
require_once '../../config/db.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: ../../login.php");
    exit();
}

$current_user = $_SESSION['username'] ?? '';
$current_role = $_SESSION['role'] ?? 'User';
$current_branch = $_SESSION['branch_id'] ?? 0;

if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

// Fetch vehicles for this branch or all if admin
$vehicles = [];
if ($current_role === 'Admin') {
    $result = $conn->query("SELECT id, plate_number FROM vehicles ORDER BY plate_number ASC");
} else {
    $stmt = $conn->prepare("SELECT id, plate_number FROM vehicles WHERE branch_id = ?");
    $stmt->bind_param("i", $current_branch);
    $stmt->execute();
    $result = $stmt->get_result();
}
while ($row = $result->fetch_assoc()) {
    $vehicles[] = $row;
}

include_once '../../includes/layout2.php';
?>

<div class="main-content p-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="fw-bold text-primary">
            <i class="fas fa-gas-pump me-2"></i> Add Fuel Refill Entry
        </h4>
        <a href="fuel_logs.php" class="btn btn-secondary"><i class="fas fa-list me-1"></i> Fuel Logs</a>
    </div>

    <?php if (isset($_SESSION['error'])): ?>
        <div class="alert alert-danger"><?= $_SESSION['error']; unset($_SESSION['error']); ?></div>
    <?php endif; ?>
    <?php if (isset($_SESSION['success'])): ?>
        <div class="alert alert-success"><?= $_SESSION['success']; unset($_SESSION['success']); ?></div>
    <?php endif; ?>

    <form method="POST" action="save_fuel.php" class="card shadow p-4">
        <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">

        <div class="row g-3">
            <div class="col-md-4">
                <label class="form-label">Vehicle *</label>
                <select name="vehicle_id" class="form-select" required>
                    <option value="">-- Select Vehicle --</option>
                    <?php foreach ($vehicles as $v): ?>
                        <option value="<?= $v['id'] ?>"><?= htmlspecialchars($v['plate_number']) ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-md-4">
                <label class="form-label">Fuel Date *</label>
                <input type="date" name="fuel_date" class="form-control" value="<?= date('Y-m-d') ?>" required>
            </div>
            <div class="col-md-4">
                <label class="form-label">Station Name *</label>
                <input type="text" name="station" class="form-control" required>
            </div>
            <div class="col-md-3">
                <label class="form-label">Liters Filled *</label>
                <input type="number" step="0.1" name="liters" class="form-control" required>
            </div>
            <div class="col-md-3">
                <label class="form-label">Total Cost (Ksh) *</label>
                <input type="number" step="0.01" name="cost" class="form-control" required>
            </div>
            <div class="col-md-3">
                <label class="form-label">Odometer (km)</label>
                <input type="number" step="1" name="odometer" class="form-control">
            </div>
            <div class="col-md-12">
                <label class="form-label">Remarks</label>
                <textarea name="remarks" class="form-control" rows="2"></textarea>
            </div>
        </div>

        <div class="mt-4">
            <button type="submit" class="btn btn-primary px-4">
                <i class="fas fa-save me-1"></i> Save Entry
            </button>
        </div>
    </form>
</div>

<?php include_once '../../includes/footer.php'; ?>
