<?php
require_once '../../config/db.php';
require_once '../../lib/zkteco/src/Lib/ZKTeco.php';
require_once '../../lib/zkteco/src/Lib/Helper/Connect.php';
require_once '../../lib/zkteco/src/Lib/Helper/Util.php';
require_once '../../lib/zkteco/src/Lib/Helper/User.php';
require_once '../../lib/zkteco/src/Lib/Helper/Attendance.php';

use Jmrashed\Zkteco\Lib\ZKTeco;

$zk = new ZKTeco('192.168.1.247'); // IP of the ZKTeco device

try {
    $zk->connect();
    $users = $zk->getUser();
    $updated = 0;

    foreach ($users as $user) {
        $uid = $user['uid'] ?? '';
        $userId = $user['userid'] ?? '';
        $name = $user['name'] ?? '';

        if (empty($uid) || empty($userId)) continue;

        // Assuming the userId = national_id
        $stmt = $conn->prepare("UPDATE staff SET zk_uid = ? WHERE national_id = ?");
        $stmt->bind_param('ss', $uid, $userId);
        $stmt->execute();

        if ($stmt->affected_rows > 0) {
            $updated++;
        }

        $stmt->close();
    }

    echo "✅ Updated ZK UID for $updated staff record(s).";
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage();
}
?>