<?php
session_start();
require_once '../../config/db.php';
include '../../includes/layout2.php';

$today = date('Y-m-d');

$query = "
  SELECT c.*, s.name AS supplier_name
  FROM credit_notes c
  JOIN suppliers s ON c.supplier_id = s.id
  ORDER BY c.credit_date DESC
";
$result = $conn->query($query);
?>

<div class="main-content">
  <div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="fw-bold text-primary"><i class="fas fa-clipboard-list me-2"></i> All Credit Notes</h4>
    <div class="btn-group">
      <a href="add.php" class="btn btn-sm btn-primary"><i class="fas fa-plus-circle me-1"></i> Add Credit Note</a>
      <a href="export_credit_csv.php" class="btn btn-sm btn-outline-success"><i class="fas fa-file-csv"></i> CSV</a>
      <a href="export_credit_pdf.php" class="btn btn-sm btn-outline-danger"><i class="fas fa-file-pdf"></i> PDF</a>
    </div>
  </div>

  <?php if (isset($_SESSION['success'])): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
      <?= $_SESSION['success'] ?>
      <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
    <?php unset($_SESSION['success']); ?>
  <?php endif; ?>

  <?php if (isset($_SESSION['error'])): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
      <?= $_SESSION['error'] ?>
      <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
    <?php unset($_SESSION['error']); ?>
  <?php endif; ?>

  <div class="card border-0 shadow-sm">
    <div class="card-body table-responsive">
      <table class="table table-bordered table-hover align-middle small">
        <thead class="table-dark text-center">
          <tr>
            <th>#</th>
            <th>Supplier</th>
            <th>Credit No.</th>
            <th>Date</th>
            <th>Amount (KSh)</th>
            <th>Reason</th>
            <th>PDF</th>
          </tr>
        </thead>
        <tbody>
          <?php if ($result->num_rows > 0): $n = 1; ?>
            <?php while ($row = $result->fetch_assoc()): ?>
              <?php $is_today = ($row['credit_date'] === $today); ?>
              <tr class="<?= $is_today ? 'table-success' : '' ?>">
                <td class="text-center"><?= $n++ ?></td>
                <td><?= htmlspecialchars($row['supplier_name']) ?></td>
                <td><span class="badge bg-secondary"><?= htmlspecialchars($row['credit_note_number']) ?></span></td>
                <td><?= date('d-M-Y', strtotime($row['credit_date'])) ?></td>
                <td class="text-end fw-bold text-success">KSh <?= number_format($row['amount'], 2) ?></td>
                <td><?= htmlspecialchars($row['reason']) ?></td>
                <td class="text-center">
                  <?php if ($row['file_path']): ?>
                    <a href="../../assets/uploads/credit_notes/<?= $row['file_path'] ?>" target="_blank" class="btn btn-sm btn-outline-secondary" title="Open PDF">
                      <i class="fas fa-file-pdf"></i>
                    </a>
                  <?php else: ?>
                    <span class="text-muted">None</span>
                  <?php endif; ?>
                </td>
              </tr>
            <?php endwhile; ?>
          <?php else: ?>
            <tr><td colspan="7" class="text-center text-muted">No credit notes found.</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
