<?php
session_start();
require_once '../../config/db.php';
include '../../includes/layout2.php';

// Optional filters
$where = "1=1";
$params = [];
$types = "";

if (!empty($_GET['bank_id'])) {
    $where .= " AND ba.id = ?";
    $params[] = $_GET['bank_id'];
    $types .= "i";
}
if (!empty($_GET['from']) && !empty($_GET['to'])) {
    $where .= " AND c.payment_date BETWEEN ? AND ?";
    $params[] = $_GET['from'];
    $params[] = $_GET['to'];
    $types .= "ss";
}

$sql = "
    SELECT c.*, cl.serial_number, cb.book_number, ba.bank_name, ba.account_number
    FROM cheques c
    JOIN cheque_leaves cl ON c.cheque_leaf_id = cl.id
    JOIN cheque_books cb ON cl.cheque_book_id = cb.id
    JOIN bank_accounts ba ON cb.bank_account_id = ba.id
    WHERE $where
    ORDER BY c.payment_date DESC
";
$stmt = $conn->prepare($sql);
if ($types) {
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$cheques = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);

$banks = $conn->query("SELECT id, bank_name, account_number FROM bank_accounts ORDER BY bank_name")->fetch_all(MYSQLI_ASSOC);
?>

<div class="container mt-4">
    <h3 class="fw-bold mb-3">Issued Cheques</h3>

    <form method="GET" class="row g-3 mb-4 shadow-sm p-3 bg-light rounded">
        <div class="col-md-4">
            <label class="form-label">Bank Account</label>
            <select name="bank_id" class="form-select">
                <option value="">-- All Banks --</option>
                <?php foreach ($banks as $b): ?>
                    <option value="<?= $b['id'] ?>" <?= ($_GET['bank_id'] ?? '') == $b['id'] ? 'selected' : '' ?>>
                        <?= $b['bank_name'] ?> - <?= $b['account_number'] ?>
                    </option>
                <?php endforeach ?>
            </select>
        </div>
        <div class="col-md-2">
            <label class="form-label">From</label>
            <input type="date" name="from" class="form-control" value="<?= $_GET['from'] ?? '' ?>">
        </div>
        <div class="col-md-2">
            <label class="form-label">To</label>
            <input type="date" name="to" class="form-control" value="<?= $_GET['to'] ?? '' ?>">
        </div>
        <div class="col-md-2 d-flex align-items-end">
            <button type="submit" class="btn btn-primary w-100">🔍 Filter</button>
        </div>
        <div class="col-md-2 d-flex align-items-end">
            <a href="list_cheques.php" class="btn btn-secondary w-100">🔄 Reset</a>
        </div>
    </form>

    <table class="table table-striped table-bordered">
        <thead class="table-light">
            <tr>
                <th>#</th>
                <th>Date</th>
                <th>Payee</th>
                <th>Amount</th>
                <th>Bank</th>
                <th>Leaf</th>
                <th>Status</th>
                <th>Reason</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach ($cheques as $i => $c): ?>
            <tr>
                <td><?= $i + 1 ?></td>
                <td><?= date('d M Y', strtotime($c['payment_date'])) ?></td>
                <td><?= htmlspecialchars($c['payee_name']) ?></td>
                <td>Ksh <?= number_format($c['amount'], 2) ?></td>
                <td><?= $c['bank_name'] ?> (<?= $c['account_number'] ?>)</td>
                <td><?= $c['book_number'] ?> / <?= $c['serial_number'] ?></td>
                <td>
                    <span class="badge bg-<?= $c['status'] === 'cancelled' ? 'danger' : ($c['status'] === 'printed' ? 'success' : 'secondary') ?>">
                        <?= ucfirst($c['status']) ?>
                    </span>
                </td>
                <td><?= htmlspecialchars($c['reason']) ?></td>
                <td>
                    <a href="print_cheque.php?id=<?= $c['id'] ?>" class="btn btn-sm btn-outline-dark" target="_blank">🖨 Print</a>
                    <?php if ($c['status'] !== 'cancelled'): ?>
                        <a href="cancel_cheque.php?id=<?= $c['id'] ?>" onclick="return confirm('Cancel this cheque?')" class="btn btn-sm btn-outline-danger">❌ Cancel</a>
                    <?php endif ?>
                </td>
            </tr>
        <?php endforeach ?>
        </tbody>
    </table>
</div>
