<?php
session_start();
require_once '../../config/db.php';


// Auto-convert number to words (basic)
function numberToWords($num) {
    $f = new NumberFormatter("en", NumberFormatter::SPELLOUT);
    return ucwords($f->format($num));
}

// Handle cheque issue
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $cheque_leaf_id = (int) $_POST['cheque_leaf_id'];
    $payee_name = trim($_POST['payee_name']);
    $amount = (float) $_POST['amount'];
    $payment_date = $_POST['payment_date'];
    $reason = trim($_POST['reason']);
    $printed_by = $_SESSION['user_id'] ?? 1; // fallback to 1
    $amount_words = numberToWords($amount);

    // Insert into cheques table
    $stmt = $conn->prepare("INSERT INTO cheques (cheque_leaf_id, payee_name, amount, amount_words, payment_date, reason, printed_by, printed_at, status) 
                            VALUES (?, ?, ?, ?, ?, ?, ?, NOW(), 'printed')");
    $stmt->bind_param("isdsssi", $cheque_leaf_id, $payee_name, $amount, $amount_words, $payment_date, $reason, $printed_by);
    $stmt->execute();

    // Mark cheque leaf as used
    $conn->query("UPDATE cheque_leaves SET status = 'used', issued_to = '$payee_name', issued_date = '$payment_date' WHERE id = $cheque_leaf_id");

    // ✅ Auto-update cheque_book status to 'exhausted' if no more available leaves
    $sql = "
        UPDATE cheque_books
        SET status = 'exhausted'
        WHERE id = (
            SELECT book_id FROM (
                SELECT cheque_book_id AS book_id FROM cheque_leaves WHERE id = ?
            ) AS temp
        )
        AND NOT EXISTS (
            SELECT 1 FROM cheque_leaves
            WHERE cheque_leaves.cheque_book_id = cheque_books.id
            AND cheque_leaves.status = 'available'
        )
    ";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $cheque_leaf_id);
    $stmt->execute();

    header("Location: issue_cheque.php?success=1");
    exit;
}

// Fetch available leaves with bank info
$leaves = $conn->query("
    SELECT cl.id, cl.serial_number, cb.book_number, ba.bank_name, ba.account_number
    FROM cheque_leaves cl
    JOIN cheque_books cb ON cl.cheque_book_id = cb.id
    JOIN bank_accounts ba ON cb.bank_account_id = ba.id
    WHERE cl.status = 'available'
    ORDER BY cl.serial_number ASC
")->fetch_all(MYSQLI_ASSOC);
include '../../includes/layout2.php';
?>

<div class="container mt-4">
    <h3 class="fw-bold mb-4">Issue Cheque</h3>

    <?php if (isset($_GET['success'])): ?>
        <div class="alert alert-success">Cheque successfully issued and saved.</div>
    <?php endif ?>

    <form method="POST" class="card p-4 shadow-sm">
        <div class="row g-3">
            <div class="col-md-5">
                <label class="form-label">Select Available Cheque Leaf</label>
                <select name="cheque_leaf_id" class="form-select" required>
                    <option value="">-- Select Cheque Leaf --</option>
                    <?php foreach ($leaves as $l): ?>
                        <option value="<?= $l['id'] ?>">
                            <?= $l['bank_name'] ?> (<?= $l['account_number'] ?>) - Book <?= $l['book_number'] ?> - Leaf #<?= $l['serial_number'] ?>
                        </option>
                    <?php endforeach ?>
                </select>
            </div>
            <div class="col-md-4">
                <label class="form-label">Payee Name</label>
                <input type="text" name="payee_name" class="form-control" required>
            </div>
            <div class="col-md-3">
                <label class="form-label">Amount (Ksh)</label>
                <input type="number" step="0.01" name="amount" class="form-control" required>
            </div>
            <div class="col-md-3">
                <label class="form-label">Payment Date</label>
                <input type="date" name="payment_date" class="form-control" required value="<?= date('Y-m-d') ?>">
            </div>
            <div class="col-md-9">
                <label class="form-label">Payment Reason</label>
                <input type="text" name="reason" class="form-control" required>
            </div>
            <div class="col-md-3 d-flex align-items-end">
                <button type="submit" class="btn btn-success w-100">Save & Issue</button>
            </div>
        </div>
    </form>
</div>
