<?php
session_start();
require_once '../../config/db.php';
include '../../includes/layout2.php';

// Enable error reporting for debugging
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Cheque Management</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" rel="stylesheet">
  <style>
    body { background: #f4f6f8; font-size: 13px; }
    .header {
      background: #007bff;
      color: #fff;
      padding: 15px;
      border-radius: 4px;
      margin-bottom: 20px;
      border-bottom: 2px solid #0056b3;
    }
    .card { margin-bottom: 20px; }
    .btn-primary {
      background-color: #007bff;
      border-color: #007bff;
    }
    .btn-primary:hover {
      background-color: #0056b3;
      border-color: #0056b3;
    }
  </style>
</head>
<body>
<main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
  <div class="container my-4">
    <div class="header text-center">
      <h4 class="fw-bold">CHEQUE MANAGEMENT</h4>
    </div>

    <div class="row">
      <div class="col-md-4">
        <div class="card">
          <div class="card-body text-center">
            <h5 class="card-title">Create Cheque</h5>
            <p class="card-text">Issue a new cheque for payments.</p>
            <a href="create_cheque.php" class="btn btn-primary"><i class="fas fa-plus"></i> Create</a>
          </div>
        </div>
      </div>
      <div class="col-md-4">
        <div class="card">
          <div class="card-body text-center">
            <h5 class="card-title">View Cheques</h5>
            <p class="card-text">Browse and manage issued cheques.</p>
            <a href="view_cheques.php" class="btn btn-primary"><i class="fas fa-eye"></i> View</a>
          </div>
        </div>
      </div>
      <div class="col-md-4">
        <div class="card">
          <div class="card-body text-center">
            <h5 class="card-title">Manage Cheque Books</h5>
            <p class="card-text">Add and track cheque books.</p>
            <a href="manage_cheque_books.php" class="btn btn-primary"><i class="fas fa-book"></i> Manage</a>
          </div>
        </div>
      </div>
      <div class="col-md-4">
        <div class="card">
          <div class="card-body text-center">
            <h5 class="card-title">Print Cheques</h5>
            <p class="card-text">Design and print cheques.</p>
            <a href="view_cheques.php" class="btn btn-primary"><i class="fas fa-print"></i> Print</a>
          </div>
        </div>
      </div>
      <div class="col-md-4">
        <div class="card">
          <div class="card-body text-center">
            <h5 class="card-title">Cheque Reports</h5>
            <p class="card-text">Generate cheque-related reports.</p>
            <a href="cheque_reports.php" class="btn btn-primary"><i class="fas fa-chart-bar"></i> Reports</a>
          </div>
        </div>
      </div>
    </div>
  </div>
</main>

<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>