<?php
session_start();
require_once '../../config/db.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    $_SESSION['error'] = "Invalid access method.";
    header("Location: returns.php");
    exit;
}

$delivery_id = (int)($_POST['loading_id'] ?? 0); // from the form
$mileage_end = (int)($_POST['mileage_end'] ?? 0);
$returned = $_POST['returned'] ?? [];

if ($delivery_id <= 0 || $mileage_end <= 0 || empty($returned)) {
    $_SESSION['error'] = "Missing required return information.";
    header("Location: returns.php?loading_id=" . $delivery_id);
    exit;
}

// Check if loading/delivery exists
$check_stmt = $conn->prepare("SELECT id FROM loadings WHERE id = ?");
$check_stmt->bind_param("i", $delivery_id);
$check_stmt->execute();
$check_result = $check_stmt->get_result();

if ($check_result->num_rows === 0) {
    $_SESSION['error'] = "Invalid loading session.";
    header("Location: returns.php");
    exit;
}

// Begin transaction
$conn->begin_transaction();

try {
    foreach ($returned as $sku_id => $data) {
        $crates = isset($data['crates']) ? (int)$data['crates'] : 0;
        $pieces = isset($data['pieces']) ? (int)$data['pieces'] : 0;

        if ($crates > 0 || $pieces > 0) {
            $insert_stmt = $conn->prepare("
                INSERT INTO returns (delivery_id, sku_id, returned_crates, returned_pieces)
                VALUES (?, ?, ?, ?)
            ");
            if (!$insert_stmt) {
                throw new Exception("Prepare failed: " . $conn->error);
            }
            $insert_stmt->bind_param("iiii", $delivery_id, $sku_id, $crates, $pieces);
            $insert_stmt->execute();
        }
    }

    // Update end mileage
    $update_stmt = $conn->prepare("UPDATE loadings SET mileage_end = ? WHERE id = ?");
    $update_stmt->bind_param("ii", $mileage_end, $delivery_id);
    $update_stmt->execute();

    $conn->commit();
    $_SESSION['success'] = "Returns recorded successfully!";
    header("Location: view_returns.php?loading_id=" . $delivery_id);
    exit;

} catch (Exception $e) {
    $conn->rollback();
    $_SESSION['error'] = "Failed to save returns: " . $e->getMessage();
    header("Location: returns.php?loading_id=" . $delivery_id);
    exit;
}
?>
