<?php
session_start();
require_once '../../config/db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get and sanitize inputs
    $vehicle_id = (int)($_POST['vehicle_id'] ?? 0);
    $route_id = (int)($_POST['route_id'] ?? 0);
    $loading_date = $_POST['loading_date'] ?? '';
    $mileage_start = (int)($_POST['mileage_start'] ?? 0);
    $remarks = trim($_POST['remarks'] ?? '');
    $created_by = $_SESSION['user_name'] ?? 'admin';
    $crates = $_POST['crates'] ?? [];

    // Basic validation
    if ($vehicle_id <= 0 || $route_id <= 0 || empty($loading_date) || !is_array($crates) || empty($crates)) {
        $_SESSION['error'] = "Please fill in all required fields.";
        header("Location: loading.php");
        exit;
    }

    // Start transaction
    $conn->begin_transaction();

    try {
        // Insert main loading entry
        $stmt = $conn->prepare("INSERT INTO loadings (vehicle_id, route_id, loading_date, mileage_start, created_by, remarks) VALUES (?, ?, ?, ?, ?, ?)");
        if (!$stmt) throw new Exception("Failed to prepare loading insert: " . $conn->error);
        $stmt->bind_param('iissss', $vehicle_id, $route_id, $loading_date, $mileage_start, $created_by, $remarks);
        $stmt->execute();
        $loading_id = $conn->insert_id;

        // Insert each loading item
        foreach ($crates as $sku_id => $qty) {
            $sku_id = (int)$sku_id;
            $qty = (int)$qty;
            if ($qty > 0) {
                $stmt_item = $conn->prepare("INSERT INTO loading_items (loading_id, sku_id, crates_loaded) VALUES (?, ?, ?)");
                if (!$stmt_item) throw new Exception("Failed to prepare item insert: " . $conn->error);
                $stmt_item->bind_param('iii', $loading_id, $sku_id, $qty);
                $stmt_item->execute();
            }
        }

        // Commit if all is good
        $conn->commit();

        // Redirect to printable loading sheet
        header("Location: loading_sheet.php?id=" . $loading_id);
        exit;

    } catch (Exception $e) {
        $conn->rollback();
        $_SESSION['error'] = "Error saving loading: " . $e->getMessage();
        header("Location: loading.php");
        exit;
    }

} else {
    header("Location: loading.php");
    exit;
}
