<?php
session_start();
require_once '../../config/db.php';
include '../../includes/layout2.php';

$start = $_GET['start_date'] ?? date('Y-m-d', strtotime('-7 days'));
$end = $_GET['end_date'] ?? date('Y-m-d');
$vehicle = $_GET['vehicle'] ?? '';
$route = $_GET['route'] ?? '';

$where = "l.loading_date BETWEEN '$start' AND '$end'";
if ($vehicle) $where .= " AND v.vehicle_no = '" . $conn->real_escape_string($vehicle) . "'";
if ($route) $where .= " AND r.name = '" . $conn->real_escape_string($route) . "'";

// Fetch loadings
$sql = "
SELECT 
    l.id, l.loading_date, v.vehicle_no, v.driver_name, r.name AS route_name,
    l.mileage_start, l.mileage_end
FROM loadings l
JOIN vehicles v ON l.vehicle_id = v.id
JOIN routes r ON l.route_id = r.id
WHERE $where
ORDER BY l.loading_date DESC
";
$loadings = $conn->query($sql)->fetch_all(MYSQLI_ASSOC);

$loading_data = [];

foreach ($loadings as $row) {
    $lid = $row['id'];
    $mileage_start = (int)$row['mileage_start'];
    $mileage_end = (int)$row['mileage_end'];
    $distance = max(0, $mileage_end - $mileage_start);

    // Load items
    $items = $conn->query("
        SELECT li.sku_id, s.name AS sku_name, li.crates_loaded, s.loaves_per_crate, s.price_per_crate
        FROM loading_items li
        JOIN skus s ON li.sku_id = s.id
        WHERE li.loading_id = $lid
    ")->fetch_all(MYSQLI_ASSOC);

    $returns = $conn->query("
        SELECT sku_id, returned_crates, returned_pieces
        FROM returns
        WHERE delivery_id = $lid
    ")->fetch_all(MYSQLI_ASSOC);

    $returns_lookup = [];
    foreach ($returns as $r) {
        $returns_lookup[$r['sku_id']] = [
            'crates' => $r['returned_crates'],
            'pieces' => $r['returned_pieces']
        ];
    }

    $total_loaded = $total_returned = $total_sold = $total_value = $deficit = 0;

    foreach ($items as $it) {
        $loaded = $it['crates_loaded'] * $it['loaves_per_crate'];
        $ret_crates = $returns_lookup[$it['sku_id']]['crates'] ?? 0;
        $ret_pieces = $returns_lookup[$it['sku_id']]['pieces'] ?? 0;
        $returned = ($ret_crates * $it['loaves_per_crate']) + $ret_pieces;
        $sold = $loaded - $returned;
        $val = ($sold / $it['loaves_per_crate']) * $it['price_per_crate'];
        $def = $loaded - ($sold + $returned);

        $total_loaded += $loaded;
        $total_returned += $returned;
        $total_sold += $sold;
        $total_value += $val;
        $deficit += $def;
    }

    $payment = $conn->query("SELECT cash_amount, mpesa_amount, cheque_amount FROM bread_payments WHERE loading_id = $lid ORDER BY id DESC LIMIT 1")->fetch_assoc();
    $paid = $payment ? $payment['cash_amount'] + $payment['mpesa_amount'] + $payment['cheque_amount'] : 0;

    $loading_data[] = [
        'date' => $row['loading_date'],
        'vehicle' => $row['vehicle_no'],
        'route' => $row['route_name'],
        'driver' => $row['driver_name'],
        'loaded' => $total_loaded,
        'returned' => $total_returned,
        'sold' => $total_sold,
        'deficit' => $deficit,
        'value' => $total_value,
        'paid' => $paid,
        'balance' => $total_value - $paid,
        'distance' => $distance
    ];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Bread Distribution Summary</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>@media print { .no-print { display: none; } }</style>
</head>
<body>
<div class="container my-4">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h4 class="text-primary">📦 Bread Distribution Summary</h4>
    <button onclick="window.print()" class="btn btn-dark btn-sm no-print">🖨️ Print</button>
  </div>

  <form method="GET" class="row g-3 mb-4 no-print">
    <div class="col-md-3">
      <label class="form-label">Start Date</label>
      <input type="date" name="start_date" value="<?= $start ?>" class="form-control">
    </div>
    <div class="col-md-3">
      <label class="form-label">End Date</label>
      <input type="date" name="end_date" value="<?= $end ?>" class="form-control">
    </div>
    <div class="col-md-2">
      <label class="form-label">Vehicle</label>
      <input type="text" name="vehicle" value="<?= htmlspecialchars($vehicle) ?>" class="form-control" placeholder="e.g. KBN 123Z">
    </div>
    <div class="col-md-2">
      <label class="form-label">Route</label>
      <input type="text" name="route" value="<?= htmlspecialchars($route) ?>" class="form-control" placeholder="e.g. Main">
    </div>
    <div class="col-md-2 align-self-end">
      <button type="submit" class="btn btn-primary w-100">🔍 Filter</button>
    </div>
  </form>

  <div class="table-responsive">
    <table class="table table-bordered table-striped align-middle">
      <thead class="table-light">
        <tr>
          <th>Date</th>
          <th>Vehicle</th>
          <th>Route</th>
          <th>Distance (km)</th>
          <th>Loaded (pcs)</th>
          <th>Returned</th>
          <th>Sold</th>
          <th>Deficit</th>
          <th>Value (Ksh)</th>
          <th>Paid (Ksh)</th>
          <th>Balance</th>
        </tr>
      </thead>
      <tbody>
        <?php
        $tot_loaded = $tot_returned = $tot_sold = $tot_value = $tot_paid = $tot_deficit = $tot_distance = 0;
        foreach ($loading_data as $d):
          $tot_loaded += $d['loaded'];
          $tot_returned += $d['returned'];
          $tot_sold += $d['sold'];
          $tot_value += $d['value'];
          $tot_paid += $d['paid'];
          $tot_deficit += $d['deficit'];
          $tot_distance += $d['distance'];
        ?>
        <tr>
          <td><?= $d['date'] ?></td>
          <td><?= $d['vehicle'] ?></td>
          <td><?= $d['route'] ?></td>
          <td class="text-end"><?= $d['distance'] ?></td>
          <td class="text-end"><?= $d['loaded'] ?></td>
          <td class="text-end text-danger"><?= $d['returned'] ?></td>
          <td class="text-end text-success"><?= $d['sold'] ?></td>
          <td class="text-end"><?= $d['deficit'] ?></td>
          <td class="text-end fw-bold"><?= number_format($d['value'], 2) ?></td>
          <td class="text-end text-primary"><?= number_format($d['paid'], 2) ?></td>
          <td class="text-end text-danger"><?= number_format($d['balance'], 2) ?></td>
        </tr>
        <?php endforeach; ?>
        <tr class="table-dark fw-bold">
          <td colspan="3">TOTAL</td>
          <td class="text-end"><?= $tot_distance ?></td>
          <td class="text-end"><?= $tot_loaded ?></td>
          <td class="text-end"><?= $tot_returned ?></td>
          <td class="text-end"><?= $tot_sold ?></td>
          <td class="text-end"><?= $tot_deficit ?></td>
          <td class="text-end"><?= number_format($tot_value, 2) ?></td>
          <td class="text-end"><?= number_format($tot_paid, 2) ?></td>
          <td class="text-end"><?= number_format($tot_value - $tot_paid, 2) ?></td>
        </tr>
      </tbody>
    </table>
  </div>
</div>
</body>
</html>
