<?php
namespace ZKTeco;

class Socket {
    private $ip;
    private $port;
    private $sock;

    public function __construct($ip, $port) {
        $this->ip = $ip;
        $this->port = $port;
    }

    public function connect() {
        $this->sock = socket_create(AF_INET, SOCK_DGRAM, SOL_UDP);
        if (!$this->sock) {
            throw new \Exception("Socket creation failed");
        }
        socket_connect($this->sock, $this->ip, $this->port);
    }

    public function fetchAttendance() {
        // Dummy data for illustration
        return [
            ['uid' => 'STAFF-001', 'timestamp' => date('Y-m-d H:i:s')],
            ['uid' => 'STAFF-002', 'timestamp' => date('Y-m-d H:i:s')],
        ];
    }
}
?>