<?php
// Ensure session is started only if not already active
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
// Log header version
error_log("Using header.php version: b8c9d0e1-f2g3-4h5i-6j7k-8l9m0n1o2p3");
include __DIR__ . '/../auth/auth_check.php';

// Fetch user info for control logic
$userId = $_SESSION['user_id'] ?? null;
$userRole = $_SESSION['role'] ?? null;

if ($userId && $userRole !== 'Admin') {
    // Ensure $conn is defined (assumed from auth_check.php)
    $stmt = $conn->prepare("SELECT password_changed_at, created_at FROM users WHERE id = ?");
    if ($stmt) {
        $stmt->bind_param("i", $userId);
        $stmt->execute();
        $stmt->bind_result($changedAt, $createdAt);
        if ($stmt->fetch()) {
            $lastChanged = $changedAt ?? $createdAt;
            $expiryDate = date('Y-m-d H:i:s', strtotime($lastChanged . ' +7 days'));

            if (strtotime($expiryDate) < time() && basename($_SERVER['PHP_SELF']) !== 'change_password.php') {
                header("Location: /smartpay360/auth/change_password.php?force=1");
                exit;
            }
        }
        $stmt->close();
    } else {
        error_log("Failed to prepare statement for password expiry check");
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>SmartPay360</title>

  <!-- Bootstrap & Font Awesome -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

  <!-- Favicon and Meta Tags (simplified for modern browsers) -->
  <link rel="icon" type="image/png" sizes="32x32" href="/smartpay360/assets/icons/favicon-32x32.png">
  <link rel="apple-touch-icon" sizes="180x180" href="/smartpay360/assets/icons/apple-icon-180x180.png">
  <link rel="manifest" href="/smartpay360/assets/icons/manifest.json">
  <meta name="theme-color" content="#007bff">
</head>
<body>

<!-- Navbar -->
<nav class="navbar navbar-expand-lg navbar-dark fixed-top shadow-sm" style="z-index: 1050; background: linear-gradient(to right, #007bff, #0056b3);">
  <div class="container-fluid">
    <a class="navbar-brand fw-bold d-flex align-items-center" href="/smartpay360/index.php">
      <i class="fas fa-file-invoice-dollar me-2"></i> SmartPay360
    </a>

    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarCollapse" aria-controls="navbarCollapse" aria-expanded="false" aria-label="Toggle navigation">
      <span class="navbar-toggler-icon"></span>
    </button>

    <div class="collapse navbar-collapse" id="navbarCollapse">
      <!-- Left navbar links -->
      <ul class="navbar-nav me-auto">
        <li class="nav-item">
          <a class="nav-link text-white" href="/smartpay360/index.php">Home</a>
        </li>
        <li class="nav-item">
          <a class="nav-link text-white" href="/smartpay360/modules/branches/list.php">Branches</a>
        </li>
        <li class="nav-item dropdown">
          <a class="nav-link dropdown-toggle text-white" href="#" id="staffDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
            <i class="fas fa-users me-1"></i> Staff
          </a>
          <ul class="dropdown-menu shadow-sm" aria-labelledby="staffDropdown">
            <li><a class="dropdown-item" href="/smartpay360/modules/staff/list.php"><i class="fas fa-users me-2"></i> Staff List</a></li>
            <li><a class="dropdown-item" href="/smartpay360/modules/staff/add.php"><i class="fas fa-user-plus me-2"></i> Add Staff</a></li>
            <li><a class="dropdown-item" href="/smartpay360/modules/staff/muster_roll.php"><i class="fas fa-list me-2"></i> Muster Roll</a></li>
            <li><a class="dropdown-item" href="/smartpay360/modules/staff/off_scheduling.php"><i class="fas fa-calendar-xmark me-2"></i> Off-Scheduling</a></li>
            <li><a class="dropdown-item" href="/smartpay360/modules/staff/calendar.php"><i class="fas fa-calendar me-2"></i> Calendar</a></li>
            <li><a class="dropdown-item" href="/smartpay360/modules/staff/roll_call.php"><i class="fas fa-check-square me-2"></i> Roll Call</a></li>
          </ul>

        </li>
<li class="nav-item dropdown">
  <a class="nav-link dropdown-toggle text-white" href="#" id="promotionsDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
    <i class="fas fa-bullhorn me-1"></i> Promotions
  </a>
  <ul class="dropdown-menu shadow-sm" aria-labelledby="promotionsDropdown">
    <li><a class="dropdown-item" href="/smartpay360/modules/promotions/promotions_dashboard.php"><i class="fas fa-chart-line me-2"></i> Promotions Dashboard</a></li>
    <li><a class="dropdown-item" href="/smartpay360/modules/promotions/list_promos.php"><i class="fas fa-list me-2"></i> List Promotions</a></li>
    <li><a class="dropdown-item" href="/smartpay360/modules/promotions/promotions_upload.php"><i class="fas fa-upload me-2"></i> Upload Promotion</a></li>
    <li><a class="dropdown-item" href="/smartpay360/modules/promotions/price_changes_upload.php"><i class="fas fa-tags me-2"></i> Upload Price Change</a></li>
    <li><a class="dropdown-item" href="/smartpay360/modules/promotions/inventory_promotions.php"><i class="fas fa-boxes me-2"></i> Inventory Promotions</a></li>
  </ul>
</li>

<li class="nav-item dropdown">
  <a class="nav-link dropdown-toggle text-white" href="#" id="merchDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
    <i class="fas fa-id-badge me-1"></i> Merchandisers
  </a>
  <ul class="dropdown-menu shadow-sm" aria-labelledby="merchDropdown">
    <li><a class="dropdown-item" href="/smartpay360/modules/merchandiser/list_merchandisers.php">
      <i class="fas fa-users me-2"></i> Merchandiser List</a></li>
    <li><a class="dropdown-item" href="/smartpay360/modules/merchandiser/add_merchandiser.php">
      <i class="fas fa-user-plus me-2"></i> Register Merchandiser</a></li>
    <li><a class="dropdown-item" href="/smartpay360/modules/merchandiser/merch_login.php">
      <i class="fas fa-sign-in-alt me-2"></i> Log In/Out</a></li>
    <li><a class="dropdown-item" href="/smartpay360/modules/merchandiser/log_history.php">
      <i class="fas fa-clock me-2"></i> Log History</a></li>
    <li><a class="dropdown-item" href="/smartpay360/modules/merchandiser/print_log_summary.php?branch_id=1&date=<?= date('Y-m-d') ?>">
      <i class="fas fa-print me-2"></i> Print Daily Summary</a></li>
  </ul>
</li>

        <li class="nav-item dropdown">
          <a class="nav-link dropdown-toggle text-white" href="#" id="navDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
            Quick Links
          </a>
          <ul class="dropdown-menu shadow-sm" aria-labelledby="navDropdown">
            <li><a class="dropdown-item" href="/smartpay360/modules/payments/statements.php">Supplier Statement</a></li>
            <li><a class="dropdown-item" href="/smartpay360/modules/payments/calendar.php">Payments calendar</a></li>
            <li><a class="dropdown-item" href="/smartpay360/modules/credit_notes/creditform.php">Credit form</a></li>

          </ul>
        </li>

      </ul>

      <!-- Search -->
      <form class="d-flex me-3" role="search">
        <input class="form-control form-control-sm me-2" type="search" placeholder="Search" aria-label="Search">
        <button class="btn btn-sm btn-light" type="submit"><i class="fas fa-search"></i></button>
      </form>

      <!-- User Profile -->
      <ul class="navbar-nav mb-0">
        <li class="nav-item dropdown">
          <a class="nav-link dropdown-toggle text-white" href="#" id="userDropdown" data-bs-toggle="dropdown" aria-expanded="false">
            <i class="fas fa-user-circle me-1"></i> <?= htmlspecialchars($_SESSION['user_name'] ?? 'Account') ?>
          </a>
          <ul class="dropdown-menu dropdown-menu-end shadow-sm" aria-labelledby="userDropdown">
            <?php if (isset($_SESSION['role']) && $_SESSION['role'] === 'Admin'): ?>
              <li><a class="dropdown-item" href="/smartpay360/auth/list_users.php">User Management</a></li>
              <li><hr class="dropdown-divider"></li>
            <?php endif; ?>
            <li><a class="dropdown-item text-danger"href="/smartpay360/auth/logout.php" onclick="triggerLogoutAcrossTabs()">Logout</a></li>
          </ul>
        </li>
      </ul>
    </div>
  </div>
</nav>

<!-- Sidebar -->
<div class="sidebar bg-light text-dark position-fixed vh-100 p-3 shadow-sm" style="width: 240px; top: 56px; border-right: 1px solid #dee2e6;" id="sidebar">
  <!-- Toggle Button for Mobile -->
  <button class="btn btn-outline-primary mb-3 d-lg-none" type="button" data-bs-toggle="collapse" data-bs-target="#sidebarContent" aria-expanded="true" aria-controls="sidebarContent">
    <i class="fas fa-bars"></i> Menu
  </button>

  <div class="collapse show" id="sidebarContent" style="overflow-y: auto; max-height: calc(100vh - 56px);">
    <ul class="nav flex-column">
      <li class="nav-item">
        <a class="nav-link text-dark d-flex align-items-center" href="/smartpay360/index.php">
          <i class="fas fa-home me-2"></i> Dashboard
        </a>
      </li>
      <li class="nav-item">
        <a class="nav-link text-dark d-flex align-items-center" href="/smartpay360/modules/suppliers/list.php">
          <i class="fas fa-truck me-2"></i> Suppliers
        </a>
      </li>
      <li class="nav-item">
        <a class="nav-link text-dark d-flex align-items-center" href="/smartpay360/modules/branches/list.php">
          <i class="fas fa-code-branch me-2"></i> Branches
        </a>
      </li>

      <!-- Invoices (Collapsible) -->
      <li class="nav-item">
        <a class="nav-link text-dark d-flex justify-content-between align-items-center" data-bs-toggle="collapse" href="#invoicesMenu" role="button" aria-expanded="false" aria-controls="invoicesMenu">
          <span><i class="fas fa-file-invoice me-2"></i> Invoices</span>
          <i class="fas fa-chevron-down small"></i>
        </a>
        <div class="collapse" id="invoicesMenu">
          <ul class="nav flex-column ms-3">
            <li><a class="nav-link text-dark small" href="/smartpay360/modules/invoices/list.php">All Invoices</a></li>
            <li><a class="nav-link text-dark small" href="/smartpay360/modules/invoices/add.php">Add Invoice</a></li>
            <li><a class="nav-link text-dark small" href="/smartpay360/modules/invoices/verify.php">Verify Workflow</a></li>
            <li><a class="nav-link text-dark small" href="/smartpay360/modules/invoices/approve.php">Approval Flow</a></li>
          </ul>
        </div>
      </li>

     <!-- Credit Notes (Collapsible) -->
<li class="nav-item">
  <a class="nav-link text-dark d-flex justify-content-between align-items-center" data-bs-toggle="collapse" href="#creditMenu" role="button" aria-expanded="false" aria-controls="creditMenu">
    <span><i class="fas fa-file-alt me-2"></i> Credit Notes</span>
    <i class="fas fa-chevron-down small"></i>
  </a>
  <div class="collapse" id="creditMenu">
    <ul class="nav flex-column ms-3">
      <li><a class="nav-link text-dark small" href="/smartpay360/modules/credit_notes/list.php">All Credit Notes</a></li>
      <li><a class="nav-link text-dark small" href="/smartpay360/modules/credit_notes/add.php">Add Credit Note</a></li>
    </ul>
  </div>
</li>

<!-- Goods Return Notes (Collapsible) -->
<li class="nav-item">
  <a class="nav-link text-dark d-flex justify-content-between align-items-center" data-bs-toggle="collapse" href="#returnsMenu" role="button" aria-expanded="false" aria-controls="returnsMenu">
    <span><i class="fas fa-undo-alt me-2"></i> Goods Return Notes</span>
    <i class="fas fa-chevron-down small"></i>
  </a>
  <div class="collapse" id="returnsMenu">
    <ul class="nav flex-column ms-3">
      <li><a class="nav-link text-dark small" href="/smartpay360/modules/returns/list.php">All Return Notes</a></li>
      <li><a class="nav-link text-dark small" href="/smartpay360/modules/returns/add.php">Add Return Note</a></li>
    </ul>
  </div>
</li>

      <!-- Payments (Collapsible) -->
      <li class="nav-item">
        <a class="nav-link text-dark d-flex justify-content-between align-items-center" data-bs-toggle="collapse" href="#paymentsMenu" role="button" aria-expanded="false" aria-controls="paymentsMenu">
          <span><i class="fas fa-money-check me-2"></i> Payments</span>
          <i class="fas fa-chevron-down small"></i>
        </a>
        <div class="collapse" id="paymentsMenu">
          <ul class="nav flex-column ms-3">
            <li><a class="nav-link text-dark small" href="/smartpay360/modules/payments/list.php">All Payments</a></li>
            <li><a class="nav-link text-dark small" href="/smartpay360/modules/payments/add.php">Add Payment</a></li>
            <li><a class="nav-link text-dark small" href="/smartpay360/modules/payments/receipts.php">Payment Receipts</a></li>
          </ul>
        </div>
      </li>

      <!-- Petty Cash (Collapsible) -->
      <li class="nav-item">
        <a class="nav-link text-dark d-flex justify-content-between align-items-center" data-bs-toggle="collapse" href="#pettyCashMenu" role="button" aria-expanded="false" aria-controls="pettyCashMenu">
          <span><i class="fas fa-wallet me-2"></i> Payouts</span>
          <i class="fas fa-chevron-down small"></i>
        </a>
        <div class="collapse" id="pettyCashMenu">
          <ul class="nav flex-column ms-3">
            <li><a class="nav-link text-dark small" href="/smartpay360/modules/petty_cash/list.php">All Transactions</a></li>
            <li><a class="nav-link text-dark small" href="/smartpay360/modules/petty_cash/add.php">Add Transaction</a></li>
            <li><a class="nav-link text-dark small" href="/smartpay360/modules/petty_cash/receipt.php">Petty Cash Receipts</a></li>
          </ul>
        </div>
      </li>

      <!-- Cheques -->
      <li class="nav-item">
        <a class="nav-link text-dark d-flex justify-content-between align-items-center" data-bs-toggle="collapse" href="#chequeMenu" role="button" aria-expanded="false" aria-controls="chequeMenu">
          <span><i class="fas fa-money-check-alt me-2"></i> Cheques</span>
          <i class="fas fa-chevron-down small"></i>
        </a>
        <div class="collapse" id="chequeMenu">
          <ul class="nav flex-column ms-3">
            <li><a class="nav-link text-dark small" href="/smartpay360/modules/cheques/bank_accounts.php">Bank Accounts</a></li>
            <li><a class="nav-link text-dark small" href="/smartpay360/modules/cheques/cheque_books.php">Cheque Books</a></li>
            <li><a class="nav-link text-dark small" href="/smartpay360/modules/cheques/issue_cheque.php">Issue Cheque</a></li>
            <li><a class="nav-link text-dark small" href="/smartpay360/modules/cheques/list_cheques.php">Issued Cheques</a></li>
            <li><a class="nav-link text-dark small" href="/smartpay360/modules/cheques/layout_editor.php">Layout Editor</a></li>
          </ul>
        </div>
      </li>

      <!-- Bread Module Navigation -->
      <li class="nav-item">
        <a class="nav-link text-dark d-flex justify-content-between align-items-center" data-bs-toggle="collapse" href="#breadMenu" role="button" aria-expanded="false" aria-controls="breadMenu">
          <span><i class="fas fa-bread-slice me-2"></i> Vansale</span>
          <i class="fas fa-chevron-down small"></i>
        </a>
        <div class="collapse" id="breadMenu">
          <ul class="nav flex-column ms-3">
            <li><a class="nav-link text-dark small" href="/smartpay360/modules/bread/loading.php">Load Bread</a></li>
            <li><a class="nav-link text-dark small" href="/smartpay360/modules/bread/returns.php">Record Returns</a></li>
            <li><a class="nav-link text-dark small" href="/smartpay360/modules/bread/payments.php">Collect Payment</a></li>
            <li><a class="nav-link text-dark small" href="/smartpay360/modules/bread/loading_list.php">Loading History</a></li>
            <li><a class="nav-link text-dark small" href="/smartpay360/modules/bread/payments_list.php">Payment History</a></li>
            <li><a class="nav-link text-dark small" href="/smartpay360/modules/bread/summary.php">Summary</a></li>
          </ul>
        </div>
      </li>

      <!-- Till Module Navigation -->
      <li class="nav-item">
        <a class="nav-link text-dark d-flex justify-content-between align-items-center" data-bs-toggle="collapse" href="#tillMenu" role="button" aria-expanded="false" aria-controls="tillMenu">
          <span><i class="fas fa-cash-register me-2"></i> Tills</span>
          <i class="fas fa-chevron-down small"></i>
        </a>
        <div class="collapse" id="tillMenu">
          <ul class="nav flex-column ms-3">
            <li><a class="nav-link text-dark small" href="/smartpay360/modules/till/summaries.php">Summary</a></li>
            <li><a class="nav-link text-dark small" href="/smartpay360/modules/till/cashier_report.php">Add Report</a></li>
            <li><a class="nav-link text-dark small" href="/smartpay360/modules/till/list_till_reports.php">View Reports</a></li>
            <li><a class="nav-link text-dark small" href="/smartpay360/modules/till/deposits.php">Record Deposit</a></li>
            <li><a class="nav-link text-dark small" href="/smartpay360/modules/till/deposit_list.php">View Deposits</a></li>
          </ul>
        </div>
      </li>

      <!-- Reports Menu -->
      <li class="nav-item">
        <a class="nav-link text-dark d-flex justify-content-between align-items-center" data-bs-toggle="collapse" href="#reportsMenu" role="button" aria-expanded="false" aria-controls="reportsMenu">
          <span><i class="fas fa-chart-line me-2"></i> Reports</span>
          <i class="fas fa-chevron-down small"></i>
        </a>
        <div class="collapse" id="reportsMenu">
          <ul class="nav flex-column ms-3">
            <li><a class="nav-link text-dark small" href="/smartpay360/modules/reports/summary.php"><i class="fas fa-pie-chart me-2"></i> Summary Dashboard</a></li>
            <li><a class="nav-link text-dark small" href="/smartpay360/modules/reports/invoices.php"><i class="fas fa-file-invoice me-2"></i> Invoice Report</a></li>
            <li><a class="nav-link text-dark small" href="/smartpay360/modules/reports/vat_withholding_report.php"><i class="fas fa-file-invoice me-2"></i> Vat witholding Report</a></li>
            <li><a class="nav-link text-dark small" href="/smartpay360/modules/reports/overdue_invoices.php"><i class="fas fa-exclamation-circle me-2"></i> Overdue Invoices</a></li>
            <li><a class="nav-link text-dark small" href="/smartpay360/modules/reports/invoice_status.php"><i class="fas fa-signal me-2"></i> Invoice Status Report</a></li>
            <li><a class="nav-link text-dark small" href="/smartpay360/modules/reports/aged.php"><i class="fas fa-calendar-day me-2"></i> Aged Payables</a></li>
            <li><a class="nav-link text-dark small" href="/smartpay360/modules/reports/statement.php"><i class="fas fa-list-alt me-2"></i> Supplier Statement</a></li>
            <li><a class="nav-link text-dark small" href="/smartpay360/modules/reports/supplier_payments.php"><i class="fas fa-hand-holding-usd me-2"></i> Supplier Payments</a></li>
            <li><a class="nav-link text-dark small" href="/smartpay360/modules/reports/payments.php"><i class="fas fa-file-alt me-2"></i> All Payments</a></li>
            <li><a class="nav-link text-dark small" href="/smartpay360/modules/reports/payment_trends.php"><i class="fas fa-chart-bar me-2"></i> Payment Trends</a></li>
            <li><a class="nav-link text-dark small" href="/smartpay360/modules/reports/unallocated_payments.php"><i class="fas fa-unlink me-2"></i> Unallocated Payments</a></li>
            <li><a class="nav-link text-dark small" href="/smartpay360/modules/reports/cheque_register.php"><i class="fas fa-book me-2"></i> Cheque Register</a></li>
            <li><a class="nav-link text-dark small" href="/smartpay360/modules/reports/cheque_status.php"><i class="fas fa-check-double me-2"></i> Cheque Status Report</a></li>
            <li><a class="nav-link text-dark small" href="/smartpay360/modules/reports/tax_summary.php"><i class="fas fa-percent me-2"></i> Tax Summary</a></li>
          </ul>
        </div>
      </li>

      <!-- Reconciliation Menu -->
      <li class="nav-item">
        <a class="nav-link text-dark d-flex justify-content-between align-items-center" data-bs-toggle="collapse" href="#reconciliationMenu" role="button" aria-expanded="false" aria-controls="reconciliationMenu">
          <span><i class="fas fa-balance-scale me-2"></i> Reconciliation</span>
          <i class="fas fa-chevron-down small"></i>
        </a>
        <div class="collapse" id="reconciliationMenu">
          <ul class="nav flex-column ms-3">
            <li><a class="nav-link text-dark small" href="/smartpay360/modules/reconciliation/reconcile_suppliers.php"><i class="fas fa-user-check me-2"></i> Supplier Ledger</a></li>
            <li><a class="nav-link text-dark small" href="/smartpay360/modules/reconciliation/reconcile_bank.php"><i class="fas fa-university me-2"></i> Bank Reconciliation</a></li>
            <li><a class="nav-link text-dark small" href="/smartpay360/modules/reconciliation/reconcile_cheques.php"><i class="fas fa-money-check-alt me-2"></i> Cheque Reconciliation</a></li>
            <li><a class="nav-link text-dark small" href="/smartpay360/modules/reconciliation/cheque_status_logs.php"><i class="fas fa-history me-2"></i> Status Logs</a></li>
          </ul>
        </div>
      </li>

      <!-- Logout -->
      <li class="nav-item mt-3">
        <hr class="border-light">
        <a class="nav-link text-dark small" href="/smartpay360/auth/logout.php">
          <i class="fas fa-sign-out-alt me-2"></i> Logout
        </a>
      </li>
    </ul>
  </div>
</div>

<!-- Custom CSS for Advanced Navbar and Sidebar -->
<style>
/* Navbar */
.navbar {
  transition: all 0.3s ease;
}
.navbar-brand {
  font-size: 1.5rem;
  transition: color 0.3s ease;
}
.navbar-brand:hover {
  color: #e0e0e0 !important;
}
.navbar .nav-link {
  padding: 8px 15px;
  border-radius: 5px;
  transition: all 0.3s ease;
}
.navbar .nav-link:hover {
  background-color: rgba(255, 255, 255, 0.1);
}
.navbar .nav-link.active {
  background-color: #0056b3;
  font-weight: bold;
}
.navbar .dropdown-menu {
  background-color: #007bff;
  border: 1px solid #0056b3;
  border-radius: 8px;
  box-shadow: 0 4px 12px rgba(0,0,0,0.2);
  animation: fadeIn 0.2s ease-in;
}
.navbar .dropdown-item {
  color: white;
  padding: 8px 15px;
  transition: all 0.3s ease;
}
.navbar .dropdown-item:hover {
  background-color: #0056b3;
  color: #e0e0e0;
}
.navbar .dropdown-item i {
  width: 20px;
  text-align: center;
}
@keyframes fadeIn {
  from { opacity: 0; transform: translateY(-10px); }
  to { opacity: 1; transform: translateY(0); }
}

/* Sidebar */
.sidebar {
  background-color: #f8f9fa;
  transition: all 0.3s ease;
}
.sidebar .nav-link {
  color: #333;
  border-radius: 5px;
  padding: 10px 15px;
  margin-bottom: 5px;
  transition: all 0.3s ease;
}
.sidebar .nav-link:hover {
  background-color: #e9ecef;
  color: #007bff;
  transform: translateX(5px);
}
.sidebar .nav-link.active {
  background-color: #007bff;
  color: white;
  font-weight: bold;
}
.sidebar .collapse .nav-link {
  padding: 8px 20px;
  font-size: 0.9rem;
  color: #555;
}
.sidebar .collapse .nav-link:hover {
  background-color: #e9ecef;
  color: #007bff;
}
.sidebar .collapse .nav-link.active {
  background-color: #e7f1ff;
  color: #007bff;
}
.sidebar .fa-chevron-down {
  color: #666;
  transition: transform 0.3s ease;
}
.sidebar .nav-link[aria-expanded="true"] .fa-chevron-down {
  transform: rotate(180deg);
}
.sidebar .collapse {
  transition: max-height 0.3s ease, opacity 0.3s ease;
}
.sidebar hr {
  border-color: #dee2e6;
}
.sidebar .btn-outline-primary {
  border-color: #007bff;
  color: #007bff;
}
.sidebar .btn-outline-primary:hover {
  background-color: #007bff;
  color: white;
}

/* Focus States for Accessibility */
.navbar .nav-link:focus,
.sidebar .nav-link:focus {
  outline: 2px solid #007bff;
  outline-offset: 2px;
}

/* Mobile Adjustments */
@media (max-width: 991px) {
  .sidebar {
    width: 240px;
    transform: translateX(-240px);
    transition: transform 0.3s ease;
    z-index: 1040;
  }
  .sidebar.active {
    transform: translateX(0);
  }
  .main-content {
    margin-left: 0 !important;
  }
  /* Scrollbar Styling */
  #sidebarContent::-webkit-scrollbar {
    width: 8px;
  }
  #sidebarContent::-webkit-scrollbar-thumb {
    background-color: #ccc;
    border-radius: 5px;
  }
  #sidebarContent:hover::-webkit-scrollbar-thumb {
    background-color: #999;
  }
}
@media (min-width: 992px) {
  .sidebar {
    transform: translateX(0) !important;
  }
}

</style>

<script>
document.addEventListener('DOMContentLoaded', function () {
  const currentPath = window.location.pathname;

  // === Navbar Active State ===
  document.querySelectorAll('.navbar .nav-link').forEach(link => {
    const href = link.getAttribute('href');
    if (href && currentPath.includes(href)) {
      link.classList.add('active');
      link.setAttribute('aria-current', 'page');
    }
  });

  // === Sidebar Active State ===
  document.querySelectorAll('.sidebar .nav-link').forEach(link => {
    const href = link.getAttribute('href');
    if (href && currentPath.includes(href)) {
      link.classList.add('active');
      link.setAttribute('aria-current', 'page');
      const parentCollapse = link.closest('.collapse');
      if (parentCollapse) {
        parentCollapse.classList.add('show');
        const parentLink = document.querySelector(`[href="#${parentCollapse.id}"]`);
        if (parentLink) parentLink.setAttribute('aria-expanded', 'true');
      }
    }
  });

  // === Sidebar Toggle for Mobile ===
  const sidebar = document.querySelector('.sidebar');
  const toggleButton = document.querySelector('#sidebarToggle'); // Use ID for clarity

  if (toggleButton) {
    toggleButton.addEventListener('click', () => sidebar.classList.toggle('active'));

    document.addEventListener('click', event => {
      if (!sidebar.contains(event.target) && !toggleButton.contains(event.target) && sidebar.classList.contains('active')) {
        sidebar.classList.remove('active');
      }
    });

    // Ensure desktop always shows
    window.addEventListener('resize', () => {
      if (window.innerWidth >= 992) {
        sidebar.classList.remove('active');
      }
    });
  }

  // === Inactivity Timeout ===
  const inactivityTime = 5 * 60 * 1000; // 5 minutes
  const countdownTime = 30; // 30 seconds
  let timeout, countdownInterval;

  function resetTimer() {
    clearTimeout(timeout);
    clearInterval(countdownInterval);
    timeout = setTimeout(showCountdown, inactivityTime);
  }

  function showCountdown() {
    if (currentPath.includes('logout.php')) return;

    showToast('⚠ You have been inactive. Logging out in 30 seconds...');
    let timeLeft = countdownTime;

    countdownInterval = setInterval(() => {
      updateToast(`⚠ Inactivity detected. Logging out in ${timeLeft} seconds... <button id="stayLoggedInBtn" class="btn btn-sm btn-light ms-2">Stay Logged In</button>`);
      timeLeft--;

      if (timeLeft < 0) {
        clearInterval(countdownInterval);
        triggerLogoutAcrossTabs();
       const currentPage = encodeURIComponent(window.location.pathname + window.location.search);
window.location.href = `/smartpay360/auth/logout.php?redirect=${currentPage}`;

      }
    }, 1000);
  }

  function updateToast(message) {
    const toastBody = document.querySelector('#inactivityToast .toast-body');
    if (toastBody) toastBody.innerHTML = message;

    const stayBtn = document.querySelector('#stayLoggedInBtn');
    if (stayBtn) {
      stayBtn.addEventListener('click', function handler() {
        hideToast();
        resetTimer();
        stayBtn.removeEventListener('click', handler);
      });
    }
  }

  function showToast(message, type = 'warning') {
  let toastContainer = document.querySelector('#toastContainer');
  if (!toastContainer) {
    toastContainer = document.createElement('div');
    toastContainer.id = 'toastContainer';
    toastContainer.classList.add('position-fixed', 'bottom-0', 'end-0', 'p-3');
    toastContainer.style.zIndex = 1080; // ensure above modals
    document.body.appendChild(toastContainer);
  }

  const bgClass = {
    warning: 'bg-warning',
    danger: 'bg-danger',
    info: 'bg-info',
    success: 'bg-success'
  }[type] || 'bg-warning';

  toastContainer.innerHTML = `
    <div id="inactivityToast" class="toast align-items-center text-white ${bgClass} border-0 show" role="alert" aria-live="assertive" aria-atomic="true">
      <div class="d-flex">
        <div class="toast-body">${message}</div>
        <button type="button" class="btn-close btn-close-white me-2 m-auto" aria-label="Close"></button>
      </div>
    </div>
  `;

  const closeBtn = document.querySelector('#inactivityToast .btn-close');
  closeBtn?.addEventListener('click', () => {
    hideToast();
    if (typeof resetTimer === 'function') resetTimer();
  });
}

function hideToast() {
  const toast = document.querySelector('#inactivityToast');
  if (toast) toast.remove();
}


  // === Throttle Activity Events ===
  let lastActivity = Date.now();
  const throttleDelay = 200;

  function handleActivity() {
    const now = Date.now();
    if (now - lastActivity > throttleDelay) {
      resetTimer();
      lastActivity = now;
    }
  }

  ['mousemove', 'mousedown', 'keypress', 'touchstart', 'scroll'].forEach(event =>
    window.addEventListener(event, handleActivity)
  );

  resetTimer();
  function resetTimer() {
  clearTimeout(timeout);
  clearInterval(countdownInterval);

  // 🔁 Immediately ping server to keep session alive
  fetch('/smartpay360/auth/ping_session.php', { method: 'GET' })
    .then(response => response.json())
    .then(data => {
      if (data.status === 'active') {
        timeout = setTimeout(showCountdown, inactivityTime);
      } else {
        // Session expired already – redirect now
        window.location.href = `/smartpay360/auth/session_expired.php`;
      }
    })
    .catch(() => {
      // Optionally retry or show offline warning
    });
}

  // === Periodic Session Ping (silent renew with toast + redirect) ===
const sessionPingInterval = 2 * 60 * 1000; // every 2 minutes

function startSessionPing() {
  setInterval(() => {
    fetch('/smartpay360/auth/ping_session.php', { method: 'GET' })
      .then(response => response.json())
      .then(data => {
        if (data.status !== 'active') {
          clearInterval(timeout);
          clearInterval(countdownInterval);
          hideToast();
          triggerLogoutAcrossTabs();

          const currentPage = encodeURIComponent(window.location.pathname + window.location.search);
          const redirectURL = `/smartpay360/auth/session_expired.php?redirect=${currentPage}`;

          showToast("⚠ Your session has expired. Redirecting...");
          setTimeout(() => {
            window.location.href = redirectURL;
          }, 3000); // Delay to show the toast before redirect
        }
      })
      .catch(err => {
        console.error('Session ping error:', err);
        // Optionally show a warning for network loss:
        // showToast("⚠ Lost connection to server. Attempting to reconnect...");
      });
  }, sessionPingInterval);
}

  startSessionPing();

  // === Multi-tab Sync (logout broadcast) ===
  window.addEventListener('storage', (event) => {
    if (event.key === 'logout-event') {
      alert('⚠ You have been logged out in another tab. Redirecting...');
     const currentPage = encodeURIComponent(window.location.pathname + window.location.search);
window.location.href = `/smartpay360/auth/logout.php?redirect=${currentPage}`;

    }
  });

  window.triggerLogoutAcrossTabs = function () {
    localStorage.setItem('logout-event', Date.now());
  };
});
const sessionKey = 'smartpay360_active_tab';
  const uniqueTabId = Date.now().toString();

  const sessionKey = 'smartpay360_active_tab';
const uniqueTabId = Date.now().toString();
const gracePeriod = 1000; // 1 second

function claimTabLock() {
  const existing = localStorage.getItem(sessionKey);

  if (!existing) {
    // No other tab has the lock, claim it
    localStorage.setItem(sessionKey, uniqueTabId);
  } else {
    // Possibly stale, give a grace period
    setTimeout(() => {
      const stillExists = localStorage.getItem(sessionKey);
      if (stillExists) {
        alert("⚠ SmartPay360 is already open in another tab. Please close it to continue.");
        window.location.href = '/smartpay360/auth/logout.php';
      } else {
        // Reclaim lock
        localStorage.setItem(sessionKey, uniqueTabId);
      }
    }, gracePeriod);
  }
}

claimTabLock();

window.addEventListener('beforeunload', () => {
  if (localStorage.getItem(sessionKey) === uniqueTabId) {
    localStorage.removeItem(sessionKey);
  }
});
  window.addEventListener('beforeunload', () => {
    if (localStorage.getItem(sessionKey) === uniqueTabId) {
      localStorage.removeItem(sessionKey);
    }
  });
</script>

<!-- Main Page -->
<main class="main-content" style="margin-left: 240px; padding: 80px 20px 20px;">