<?php
session_start();
require_once '../config/db.php';

if (!isset($_SESSION['reset_user_id'])) {
    header("Location: login.php");
    exit;
}

$success = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $new_password = password_hash($_POST['password'], PASSWORD_BCRYPT);
    $user_id = $_SESSION['reset_user_id'];

    $stmt = $conn->prepare("UPDATE users SET password = ? WHERE id = ?");
    $stmt->bind_param("si", $new_password, $user_id);
    $stmt->execute();

    unset($_SESSION['reset_user_id']);
    $success = "✅ Password reset successful. You may now <a href='login.php'>login</a>.";
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Reset Password | SmartPay360</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      background: linear-gradient(to right, #006494, #003554);
      font-family: 'Segoe UI', sans-serif;
    }
    .box {
      max-width: 420px;
      margin: 80px auto;
      padding: 30px;
      background: #fff;
      border-radius: 14px;
      box-shadow: 0 0 15px rgba(0,0,0,0.1);
    }
    h2 {
      color: #003554;
    }
    .btn-success {
      background-color: #198754;
      border: none;
    }
    .btn-success:hover {
      background-color: #157347;
    }
  </style>
</head>
<body>
  <div class="box">
    <h2 class="text-center mb-4">🔒 Reset Password</h2>
    <p class="text-muted text-center mb-3">Enter your new password</p>

    <?php if ($success): ?>
      <div class="alert alert-success text-center"><?= $success ?></div>
    <?php else: ?>
      <form method="post">
        <div class="mb-3">
          <label class="form-label">New Password</label>
          <input type="password" name="password" class="form-control" required autofocus>
        </div>
        <button type="submit" class="btn btn-success w-100">Reset Password</button>
      </form>
    <?php endif; ?>
  </div>
</body>
</html>
